/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.special;

import dev.architectury.utils.GameInstance;
import dev.latvian.mods.kubejs.core.CraftingContainerKJS;
import dev.latvian.mods.kubejs.recipe.ModifyRecipeCraftingGrid;
import dev.latvian.mods.kubejs.recipe.ModifyRecipeResultCallback;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientAction;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import org.jetbrains.annotations.Nullable;

public interface KubeJSCraftingRecipe
extends CraftingRecipe {
    public List<IngredientAction> kjs$getIngredientActions();

    @Nullable
    public ModifyRecipeResultCallback kjs$getModifyResult();

    public String kjs$getStage();

    default public NonNullList<ItemStack> kjs$getRemainingItems(CraftingContainer container) {
        NonNullList list = NonNullList.withSize((int)container.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, (Object)IngredientAction.getRemaining(container, i, this.kjs$getIngredientActions()));
        }
        return list;
    }

    default public ItemStack kjs$assemble(CraftingContainer container, RegistryAccess registryAccess) {
        Player player;
        if (!(this.kjs$getStage().isEmpty() || (player = KubeJSCraftingRecipe.getPlayer(((CraftingContainerKJS)container).kjs$getMenu())) != null && player.kjs$getStages().has(this.kjs$getStage()))) {
            return ItemStack.EMPTY;
        }
        ModifyRecipeResultCallback modifyResult = this.kjs$getModifyResult();
        ItemStack result = this.getResultItem(registryAccess);
        ItemStack itemStack = result = result == null || result.isEmpty() ? ItemStack.EMPTY : result.copy();
        if (modifyResult != null) {
            return modifyResult.modify(new ModifyRecipeCraftingGrid(container), result);
        }
        return result;
    }

    @Nullable
    private static Player getPlayer(AbstractContainerMenu menu) {
        if (menu instanceof CraftingMenu) {
            CraftingMenu craft = (CraftingMenu)menu;
            return craft.player;
        }
        if (menu instanceof InventoryMenu) {
            InventoryMenu inv = (InventoryMenu)menu;
            return inv.owner;
        }
        MinecraftServer server = GameInstance.getServer();
        if (server != null) {
            for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                if (player.containerMenu != menu || !menu.stillValid((Player)player)) continue;
                return player;
            }
        }
        return null;
    }
}

