/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.special;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.kubejs.recipe.KubeJSRecipeEventHandler;
import dev.latvian.mods.kubejs.recipe.ModifyRecipeResultCallback;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientAction;
import dev.latvian.mods.kubejs.recipe.special.KubeJSCraftingRecipe;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.util.UtilsJS;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ShapedKubeJSRecipe
extends ShapedRecipe
implements KubeJSCraftingRecipe {
    public static final String SHRINK_KEY = "kubejs:shrink";
    public static final String MIRROR_KEY = "kubejs:mirror";
    public static final MapCodec<ShapedRecipePattern> PATTERN_NO_SHRINK_CODEC = ShapedRecipePattern.Data.MAP_CODEC.flatXmap(ShapedKubeJSRecipe::unpackNoShrink, pattern -> pattern.data().map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Cannot encode unpacked recipe")));
    public static final MapCodec<ShapedRecipePattern> PATTERN_CODEC = new MapCodec<ShapedRecipePattern>(){

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.concat(ShapedRecipePattern.MAP_CODEC.keys(ops), Stream.of(ops.createString(ShapedKubeJSRecipe.SHRINK_KEY)));
        }

        public <T> DataResult<ShapedRecipePattern> decode(DynamicOps<T> ops, MapLike<T> input) {
            return ops.getBooleanValue(input.get(ShapedKubeJSRecipe.SHRINK_KEY)).flatMap(shrink -> {
                if (shrink.booleanValue()) {
                    return ShapedRecipePattern.MAP_CODEC.decode(ops, input);
                }
                return PATTERN_NO_SHRINK_CODEC.decode(ops, input);
            });
        }

        public <T> RecordBuilder<T> encode(ShapedRecipePattern input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            return PATTERN_NO_SHRINK_CODEC.encode((Object)input, ops, prefix).add(ShapedKubeJSRecipe.SHRINK_KEY, ops.createBoolean(false));
        }
    };
    private final boolean mirror;
    private final List<IngredientAction> ingredientActions;
    private final ModifyRecipeResultCallback modifyResult;
    private final String stage;

    public ShapedKubeJSRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result, boolean mirror, List<IngredientAction> ingredientActions, @Nullable ModifyRecipeResultCallback modifyResult, String stage) {
        super(group, category, pattern, result);
        this.mirror = mirror;
        this.ingredientActions = ingredientActions;
        this.modifyResult = modifyResult;
        this.stage = stage;
    }

    public RecipeSerializer<?> getSerializer() {
        return KubeJSRecipeEventHandler.SHAPED.get();
    }

    @Override
    public List<IngredientAction> kjs$getIngredientActions() {
        return this.ingredientActions;
    }

    @Override
    @Nullable
    public ModifyRecipeResultCallback kjs$getModifyResult() {
        return this.modifyResult;
    }

    @Override
    public String kjs$getStage() {
        return this.stage;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        return this.kjs$getRemainingItems(container);
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        return this.kjs$assemble(container, registryAccess);
    }

    public boolean matches(CraftingContainer craftingContainer, Level level) {
        for (int i = 0; i <= craftingContainer.getWidth() - this.pattern.width(); ++i) {
            for (int j = 0; j <= craftingContainer.getHeight() - this.pattern.height(); ++j) {
                if (this.mirror && this.pattern.matches(craftingContainer, i, j, true)) {
                    return true;
                }
                if (!this.pattern.matches(craftingContainer, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private static DataResult<ShapedRecipePattern> unpackNoShrink(ShapedRecipePattern.Data data) {
        List pattern = data.pattern();
        int width = ((String)pattern.get(0)).length();
        int height = pattern.size();
        NonNullList nonNullList = NonNullList.withSize((int)(width * height), (Object)Ingredient.EMPTY);
        CharArraySet charSet = new CharArraySet(data.key().keySet());
        for (int row = 0; row < pattern.size(); ++row) {
            String string = (String)pattern.get(row);
            for (int cell = 0; cell < string.length(); ++cell) {
                Ingredient ingredient;
                char symbol = string.charAt(cell);
                Ingredient ingredient2 = ingredient = symbol == ' ' ? Ingredient.EMPTY : (Ingredient)data.key().get(Character.valueOf(symbol));
                if (ingredient == null) {
                    return DataResult.error(() -> "Pattern references symbol '" + symbol + "' but it's not defined in the key");
                }
                charSet.remove(symbol);
                nonNullList.set(cell + width * row, (Object)ingredient);
            }
        }
        return !charSet.isEmpty() ? DataResult.error(() -> ShapedKubeJSRecipe.lambda$unpackNoShrink$4((CharSet)charSet)) : DataResult.success((Object)new ShapedRecipePattern(width, height, nonNullList, Optional.of(data)));
    }

    private static /* synthetic */ String lambda$unpackNoShrink$4(CharSet charSet) {
        return "Key defines symbols that aren't used in pattern: " + charSet;
    }

    public static class SerializerKJS
    implements RecipeSerializer<ShapedKubeJSRecipe> {
        private static final RecipeSerializer<ShapedRecipe> SHAPED = (RecipeSerializer)UtilsJS.cast(RegistryInfo.RECIPE_SERIALIZER.getValue(new ResourceLocation("crafting_shaped")));
        public static final Codec<ShapedKubeJSRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.strictOptionalField((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(ShapedRecipe::getGroup), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(ShapedRecipe::category), (App)PATTERN_CODEC.forGetter(recipe -> recipe.pattern), (App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("result").forGetter(shapedRecipe -> shapedRecipe.result), (App)Codec.BOOL.optionalFieldOf(ShapedKubeJSRecipe.MIRROR_KEY, (Object)true).forGetter(recipe -> recipe.mirror), (App)IngredientAction.CODEC.listOf().optionalFieldOf("kubejs:actions", List.of()).forGetter(r -> r.ingredientActions), (App)ModifyRecipeResultCallback.CODEC.optionalFieldOf("kubejs:modify_result", null).forGetter(r -> r.modifyResult), (App)Codec.STRING.optionalFieldOf("kubejs:stage", (Object)"").forGetter(r -> r.stage)).apply((Applicative)instance, ShapedKubeJSRecipe::new));

        public Codec<ShapedKubeJSRecipe> codec() {
            return CODEC;
        }

        public ShapedKubeJSRecipe fromNetwork(FriendlyByteBuf buf) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)SHAPED.fromNetwork(buf);
            byte flags = buf.readByte();
            String group = shapedRecipe.getGroup();
            CraftingBookCategory category = shapedRecipe.category();
            ShapedRecipePattern pattern = shapedRecipe.pattern;
            ItemStack result = shapedRecipe.result;
            List<IngredientAction> ingredientActions = (flags & 1) != 0 ? IngredientAction.readList(buf) : List.of();
            String stage = (flags & 2) != 0 ? buf.readUtf() : "";
            boolean mirror = (flags & 4) != 0;
            return new ShapedKubeJSRecipe(group, category, pattern, result, mirror, ingredientActions, null, stage);
        }

        public void toNetwork(FriendlyByteBuf buf, ShapedKubeJSRecipe r) {
            SHAPED.toNetwork(buf, (Recipe)r);
            int flags = 0;
            if (r.ingredientActions != null && !r.ingredientActions.isEmpty()) {
                flags |= 1;
            }
            if (r.mirror) {
                flags |= 4;
            }
            if (!r.stage.isEmpty()) {
                flags |= 2;
            }
            buf.writeByte(flags);
            if (r.ingredientActions != null && !r.ingredientActions.isEmpty()) {
                IngredientAction.writeList(buf, r.ingredientActions);
            }
            if (!r.stage.isEmpty()) {
                buf.writeUtf(r.stage);
            }
        }
    }
}

