/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.special;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.kubejs.recipe.KubeJSRecipeEventHandler;
import dev.latvian.mods.kubejs.recipe.ModifyRecipeResultCallback;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientAction;
import dev.latvian.mods.kubejs.recipe.special.KubeJSCraftingRecipe;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import org.jetbrains.annotations.Nullable;

public class ShapelessKubeJSRecipe
extends ShapelessRecipe
implements KubeJSCraftingRecipe {
    private final List<IngredientAction> ingredientActions;
    private final ModifyRecipeResultCallback modifyResult;
    private final String stage;

    public ShapelessKubeJSRecipe(ShapelessRecipe original, List<IngredientAction> ingredientActions, @Nullable ModifyRecipeResultCallback modifyResult, String stage) {
        super(original.getGroup(), original.category(), original.result, original.getIngredients());
        this.ingredientActions = ingredientActions;
        this.modifyResult = modifyResult;
        this.stage = stage;
    }

    public RecipeSerializer<?> getSerializer() {
        return KubeJSRecipeEventHandler.SHAPELESS.get();
    }

    @Override
    public List<IngredientAction> kjs$getIngredientActions() {
        return this.ingredientActions;
    }

    @Override
    @Nullable
    public ModifyRecipeResultCallback kjs$getModifyResult() {
        return this.modifyResult;
    }

    @Override
    public String kjs$getStage() {
        return this.stage;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        return this.kjs$getRemainingItems(container);
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        return this.kjs$assemble(container, registryAccess);
    }

    public static class SerializerKJS
    implements RecipeSerializer<ShapelessKubeJSRecipe> {
        private static final RecipeSerializer<ShapelessRecipe> SHAPELESS = (RecipeSerializer)UtilsJS.cast(RegistryInfo.RECIPE_SERIALIZER.getValue(new ResourceLocation("crafting_shapeless")));
        private static final MapCodec.MapCodecCodec<ShapelessRecipe> SHAPELESS_CODEC = SerializerKJS.getCodec();
        public static final Codec<ShapelessKubeJSRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SHAPELESS_CODEC.codec().forGetter(r -> r), (App)IngredientAction.CODEC.listOf().optionalFieldOf("kubejs:actions", List.of()).forGetter(r -> r.ingredientActions), (App)ModifyRecipeResultCallback.CODEC.optionalFieldOf("kubejs:modify_result", null).forGetter(r -> r.modifyResult), (App)Codec.STRING.optionalFieldOf("kubejs:stage", (Object)"").forGetter(r -> r.stage)).apply((Applicative)instance, ShapelessKubeJSRecipe::new));

        private static MapCodec.MapCodecCodec<ShapelessRecipe> getCodec() {
            try {
                return (MapCodec.MapCodecCodec)UtilsJS.cast(SHAPELESS.codec());
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("Original ShapelessRecipe codec is not a MapCodecCodec!");
            }
        }

        public Codec<ShapelessKubeJSRecipe> codec() {
            return CODEC;
        }

        public ShapelessKubeJSRecipe fromNetwork(FriendlyByteBuf buf) {
            ShapelessRecipe shapelessRecipe = (ShapelessRecipe)SHAPELESS.fromNetwork(buf);
            byte flags = buf.readByte();
            List<IngredientAction> ingredientActions = (flags & 1) != 0 ? IngredientAction.readList(buf) : List.of();
            String stage = (flags & 2) != 0 ? buf.readUtf() : "";
            return new ShapelessKubeJSRecipe(shapelessRecipe, ingredientActions, null, stage);
        }

        public void toNetwork(FriendlyByteBuf buf, ShapelessKubeJSRecipe r) {
            SHAPELESS.toNetwork(buf, (Recipe)r);
            int flags = 0;
            if (r.ingredientActions != null && !r.ingredientActions.isEmpty()) {
                flags |= 1;
            }
            if (!r.stage.isEmpty()) {
                flags |= 2;
            }
            buf.writeByte(flags);
            if (r.ingredientActions != null && !r.ingredientActions.isEmpty()) {
                IngredientAction.writeList(buf, r.ingredientActions);
            }
            if (!r.stage.isEmpty()) {
                buf.writeUtf(r.stage);
            }
        }
    }
}

