/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.clienttweaks.tweak;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.client.UseItemInputEvent;
import net.blay09.mods.clienttweaks.ClientTweaksConfig;
import net.blay09.mods.clienttweaks.ClientTweaksConfigData;
import net.blay09.mods.clienttweaks.tweak.AbstractClientTweak;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class NoOffhandTorchAtAll
extends AbstractClientTweak {
    public NoOffhandTorchAtAll() {
        super("noOffhandTorchAtAll");
        Balm.getEvents().onEvent(UseItemInputEvent.class, this::onRightClick);
    }

    public void onRightClick(UseItemInputEvent event) {
        if (this.isEnabled() && event.getHand() == InteractionHand.OFF_HAND) {
            ResourceLocation registryName;
            ItemStack heldItem;
            Minecraft mc = Minecraft.getInstance();
            ItemStack itemStack = heldItem = mc.player != null ? mc.player.getItemInHand(event.getHand()) : ItemStack.EMPTY;
            if (!heldItem.isEmpty() && (registryName = Balm.getRegistries().getKey(heldItem.getItem())) != null && ClientTweaksConfig.getActive().customization.torchItems.contains(registryName.toString())) {
                event.setCanceled(true);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return ClientTweaksConfig.getActive().tweaks.noOffhandTorchAtAll;
    }

    @Override
    public void setEnabled(boolean enabled) {
        Balm.getConfig().updateConfig(ClientTweaksConfigData.class, it -> {
            it.tweaks.noOffhandTorchAtAll = enabled;
        });
    }
}

