/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.clienttweaks.tweak;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.balm.api.event.client.ClientStartedEvent;
import net.blay09.mods.clienttweaks.ClientTweaksConfig;
import net.blay09.mods.clienttweaks.ClientTweaksConfigData;
import net.blay09.mods.clienttweaks.tweak.AbstractClientTweak;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class StepAssistIsAnnoying
extends AbstractClientTweak {
    private static final float DEFAULT_STEP_HEIGHT = 0.6f;
    private final AttributeModifier disableStepAssistModifier = new AttributeModifier("Disable step assist", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private Attribute stepHeightAttribute;

    public StepAssistIsAnnoying() {
        super("disableStepAssist");
        Balm.getEvents().onEvent(ClientStartedEvent.class, event -> {
            this.stepHeightAttribute = Balm.getRegistries().getAttribute(new ResourceLocation("forge", "step_height_addition"));
        });
        Balm.getEvents().onTickEvent(TickType.Client, TickPhase.Start, this::onPlayerTick);
    }

    public void onPlayerTick(Minecraft client) {
        LocalPlayer player = client.player;
        if (player != null) {
            AttributeInstance attributeInstance;
            if (this.isEnabled()) {
                AttributeInstance attributeInstance2;
                player.setMaxUpStep(0.6f);
                if (this.stepHeightAttribute != null && (attributeInstance2 = player.getAttribute(this.stepHeightAttribute)) != null && !attributeInstance2.hasModifier(this.disableStepAssistModifier)) {
                    attributeInstance2.addTransientModifier(this.disableStepAssistModifier);
                }
            } else if (this.stepHeightAttribute != null && (attributeInstance = player.getAttribute(this.stepHeightAttribute)) != null) {
                attributeInstance.removeModifier(this.disableStepAssistModifier.getId());
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return ClientTweaksConfig.getActive().tweaks.disableStepAssist;
    }

    @Override
    public void setEnabled(boolean enabled) {
        Balm.getConfig().updateConfig(ClientTweaksConfigData.class, it -> {
            it.tweaks.disableStepAssist = enabled;
        });
    }

    @Override
    public boolean hasKeyBinding() {
        return true;
    }
}

