/*
 * Decompiled with CFR 0.152.
 */
package github.pitbox46.horsecombatcontrols.mixins;

import github.pitbox46.horsecombatcontrols.Config;
import github.pitbox46.horsecombatcontrols.HorseCombatControls;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractHorse.class})
public abstract class AbstractHorseMixinServer
extends LivingEntity {
    @Shadow
    protected float playerJumpPendingScale;
    @Shadow
    protected boolean allowStandSliding;
    @Unique
    private double horseCombatControls$prevSpeedPercent = 0.0;

    protected AbstractHorseMixinServer(EntityType<? extends LivingEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    @Shadow
    public abstract boolean isStanding();

    @Inject(at={@At(value="HEAD")}, method={"getRiddenRotation"}, cancellable=true)
    private void replaceGetRiddenRotation(LivingEntity pEntity, CallbackInfoReturnable<Vec2> cir) {
        Player player;
        if (pEntity instanceof Player && HorseCombatControls.isInCombatMode(player = (Player)pEntity)) {
            float strafingMovement = pEntity.xxa * 0.5f;
            double deltaRotRaw = Math.atan(0.05 / Math.abs(this.horseCombatControls$prevSpeedPercent)) * 180.0 / Math.PI;
            double deltaRot = Math.min(deltaRotRaw, 10.0);
            if (Math.abs(strafingMovement) == 0.0f) {
                deltaRot = 0.0;
            }
            cir.setReturnValue((Object)new Vec2(pEntity.getXRot() * 0.5f, (float)((double)this.getYRot() + deltaRot * (double)(strafingMovement < 0.0f ? 1 : -1))));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getRiddenInput"}, cancellable=true)
    private void replaceGetRiddenInput(Player pPlayer, Vec3 pTravelVector, CallbackInfoReturnable<Vec3> cir) {
        if (HorseCombatControls.isInCombatMode(pPlayer)) {
            if (this.onGround() && this.playerJumpPendingScale == 0.0f && this.isStanding() && !this.allowStandSliding) {
                cir.setReturnValue((Object)Vec3.ZERO);
                return;
            }
            float forwardMovement = pPlayer.zza;
            double maxSpeedScale = 1.0;
            double maxSpeedScaleBack = 0.25;
            double acc = maxSpeedScale * 0.05;
            if (forwardMovement > 0.0f && this.horseCombatControls$prevSpeedPercent < maxSpeedScale) {
                this.horseCombatControls$prevSpeedPercent = Math.min(maxSpeedScale, this.horseCombatControls$prevSpeedPercent + acc);
            } else if (forwardMovement < 0.0f && this.horseCombatControls$prevSpeedPercent > -maxSpeedScaleBack) {
                this.horseCombatControls$prevSpeedPercent = Math.max(-maxSpeedScaleBack, this.horseCombatControls$prevSpeedPercent - acc);
            }
            if (Math.abs(this.horseCombatControls$prevSpeedPercent) < 0.05) {
                this.horseCombatControls$prevSpeedPercent *= 0.95;
            }
            cir.setReturnValue((Object)new Vec3(0.0, 0.0, this.horseCombatControls$prevSpeedPercent));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canPerformRearing"}, cancellable=true)
    private void cancelRandomRearing(CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)Config.CANCEL_RAND_REARING.get()).booleanValue() && this.getControllingPassenger() instanceof Player && HorseCombatControls.isInCombatMode((Player)this.getControllingPassenger())) {
            cir.setReturnValue((Object)false);
        }
    }
}

