/*
 * Decompiled with CFR 0.152.
 */
package github.pitbox46.horsecombatcontrols.mixins;

import github.pitbox46.horsecombatcontrols.Config;
import github.pitbox46.horsecombatcontrols.PlayerDuck;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends Entity
implements PlayerDuck {
    @Unique
    private boolean horseCombatControls$combatMode = false;

    public PlayerMixin(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(at={@At(value="HEAD")}, method={"addAdditionalSaveData"})
    private void onAddAdditionalSaveData(CompoundTag pCompound, CallbackInfo ci) {
        pCompound.putBoolean("combatMode", this.horseCombatControls$inCombatMode());
    }

    @Inject(at={@At(value="HEAD")}, method={"readAdditionalSaveData"})
    private void onReadAdditionalSaveData(CompoundTag pCompound, CallbackInfo ci) {
        if (pCompound.contains("combatMode")) {
            this.horseCombatControls$setCombatMode(pCompound.getBoolean("combatMode"));
        } else {
            this.horseCombatControls$setCombatMode((Boolean)Config.LOCK_COMBAT_MODE.get());
        }
    }

    @Override
    public boolean horseCombatControls$inCombatMode() {
        return (Boolean)Config.LOCK_COMBAT_MODE.get() != false || this.horseCombatControls$combatMode;
    }

    @Override
    public void horseCombatControls$setCombatMode(boolean flag) {
        this.horseCombatControls$combatMode = (Boolean)Config.LOCK_COMBAT_MODE.get() != false || flag;
    }
}

