/*
 * Decompiled with CFR 0.152.
 */
package github.pitbox46.horsecombatcontrols.network;

import github.pitbox46.horsecombatcontrols.Config;
import github.pitbox46.horsecombatcontrols.HorseCombatControls;
import github.pitbox46.horsecombatcontrols.PlayerDuck;
import github.pitbox46.horsecombatcontrols.network.CombatModePacket;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ModClientPayloadHandler {
    private static final Lazy<KeyMapping> TOGGLE_CONTROLS = Lazy.of(() -> new KeyMapping("key.horsecombatcontrols.toggle", 89, "key.horsecombatcontrols.category"));
    private static final ModClientPayloadHandler INSTANCE = new ModClientPayloadHandler();

    public static ModClientPayloadHandler getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || event.phase != TickEvent.Phase.END) {
            return;
        }
        if (((KeyMapping)TOGGLE_CONTROLS.get()).consumeClick()) {
            if (((Boolean)Config.LOCK_COMBAT_MODE.get()).booleanValue()) {
                ModClientPayloadHandler.setCombatModeClientVersion((Player)player, true);
                Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"message.horsecombatcontrols.locked"), true);
            } else {
                ModClientPayloadHandler.setCombatModeClientVersion((Player)player, !HorseCombatControls.isInCombatMode((Player)player));
            }
        }
        if (((Boolean)Config.LOCK_COMBAT_MODE.get()).booleanValue() && player.level().getGameTime() % 200L == 104L && !HorseCombatControls.isInCombatMode((Player)player)) {
            ModClientPayloadHandler.setCombatModeClientVersion((Player)player, true);
            Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"message.horsecombatcontrols.locked"), true);
        }
    }

    public static void setCombatModeClientVersion(Player player, boolean flag) {
        ((PlayerDuck)player).horseCombatControls$setCombatMode(flag);
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new CombatModePacket(flag)});
    }

    public void handle(CombatModePacket msg, PlayPayloadContext ctx) {
        if (Minecraft.getInstance().player == null) {
            return;
        }
        PlayerDuck accessor = (PlayerDuck)Minecraft.getInstance().player;
        if (!accessor.horseCombatControls$inCombatMode() && msg.combatMode()) {
            Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"message.horsecombatcontrols.locked"), true);
        }
        accessor.horseCombatControls$setCombatMode(msg.combatMode());
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD, modid="horsecombatcontrols")
    static class ModEvents {
        ModEvents() {
        }

        @SubscribeEvent
        public static void registerBindings(RegisterKeyMappingsEvent event) {
            event.register((KeyMapping)TOGGLE_CONTROLS.get());
        }
    }
}

