/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import dev.shadowsoffire.placebo.util.data.RuntimeDatagenHelpers;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.commands.LootCommand;
import net.minecraft.world.level.storage.loot.LootTable;

public class SerializeLootTableCommand {
    public static final DynamicCommandExceptionType NOT_FOUND = new DynamicCommandExceptionType(arg -> Component.translatable((String)"placebo.cmd.not_found", (Object[])new Object[]{arg}));

    public static void register(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"serialize_loot_table").requires(s -> s.hasPermission(2))).then(Commands.argument((String)"loot_table", (ArgumentType)ResourceLocationArgument.id()).suggests(LootCommand.SUGGEST_LOOT_TABLE).executes(ctx -> {
            ResourceLocation id = ResourceLocationArgument.getId((CommandContext)ctx, (String)"loot_table");
            LootTable table = ((CommandSourceStack)ctx.getSource()).getServer().getServerResources().managers().getLootData().getLootTable(id);
            if (table == LootTable.EMPTY) {
                throw NOT_FOUND.create((Object)id);
            }
            if (SerializeLootTableCommand.attemptSerialize(table, id)) {
                String path = "datagen/" + id.getNamespace() + "/loot_tables/" + id.getPath() + ".json";
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"placebo.cmd.serialize_success", (Object[])new Object[]{id, path}), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"placebo.cmd.serialize_failure"));
            }
            return 0;
        })));
    }

    public static boolean attemptSerialize(LootTable table, ResourceLocation id) {
        try {
            RuntimeDatagenHelpers.write(table, LootTable.CODEC, "loot_tables", id);
            return true;
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return false;
        }
    }
}

