/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.json.NBTAdapter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;

public class StringToObjCommand {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final DynamicCommandExceptionType NOT_FOUND = new DynamicCommandExceptionType(arg -> Component.translatable((String)"placebo.cmd.not_found", (Object[])new Object[]{arg}));

    public static void register(LiteralArgumentBuilder<CommandSourceStack> builder, CommandBuildContext buildCtx) {
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"string_to_obj").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"nbt_item", (ArgumentType)ItemArgument.item((CommandBuildContext)buildCtx)).executes(ctx -> {
            try {
                String str = StringToObjCommand.toJsonStr(ItemArgument.getItem((CommandContext)ctx, (String)"nbt_item").createItemStack(1, false).getTag());
                if (((CommandSourceStack)ctx.getSource()).getPlayer() != null) {
                    ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)str));
                } else {
                    Placebo.LOGGER.info(str);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return 0;
        })));
    }

    public static String toJsonStr(CompoundTag tag) throws IOException {
        JsonElement json = (JsonElement)NBTAdapter.EITHER_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)tag).get().left().get();
        StringWriter str = new StringWriter();
        JsonWriter writer = GSON.newJsonWriter((Writer)str);
        writer.setIndent("    ");
        GSON.toJson((Object)json, JsonObject.class, writer);
        return String.format("JSON Object Form:\n%s", str.toString());
    }
}

