/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.json;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.json.NBTAdapter;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.Logger;

public class ItemAdapter {
    public static final Codec<ItemStack> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)new OptionalItemMapCodec().forGetter(ItemStack::getItem), (App)ExtraCodecs.strictOptionalField((Codec)Codec.intRange((int)1, (int)64), (String)"count", (Object)1).forGetter(ItemStack::getCount), (App)ExtraCodecs.strictOptionalField(NBTAdapter.EITHER_CODEC, (String)"nbt").forGetter(stack -> Optional.ofNullable(stack.getTag())), (App)ExtraCodecs.strictOptionalField(NBTAdapter.EITHER_CODEC, (String)"neoforge:attachments").forGetter(s -> Optional.ofNullable(s.serializeAttachments()))).apply((Applicative)inst, (item, count, nbt, capNbt) -> {
        ItemStack stack = new ItemStack((ItemLike)item, count.intValue(), (CompoundTag)capNbt.orElse(null));
        stack.setTag((CompoundTag)nbt.orElse(null));
        return stack;
    }));

    private static class OptionalItemMapCodec
    extends MapCodec<Item> {
        private final MapCodec<Item> encoder = BuiltInRegistries.ITEM.byNameCodec().fieldOf("item");
        private final MapCodec<ResourceLocation> idDecoder = ResourceLocation.CODEC.fieldOf("item");
        private final MapCodec<Boolean> optDecoder = ExtraCodecs.strictOptionalField((Codec)Codec.BOOL, (String)"optional", (Object)false);

        private OptionalItemMapCodec() {
        }

        public <T> DataResult<Item> decode(DynamicOps<T> ops, MapLike<T> input) {
            ResourceLocation id = (ResourceLocation)this.idDecoder.decode(ops, input).getOrThrow(false, arg_0 -> ((Logger)Placebo.LOGGER).error(arg_0));
            boolean optional = (Boolean)this.optDecoder.decode(ops, input).getOrThrow(false, arg_0 -> ((Logger)Placebo.LOGGER).error(arg_0));
            Item item = (Item)BuiltInRegistries.ITEM.get(id);
            if (!optional && item == Items.AIR && !id.equals((Object)BuiltInRegistries.ITEM.getKey((Object)Items.AIR))) {
                return DataResult.error(() -> "Failed to read non-optional item " + id);
            }
            return DataResult.success((Object)item);
        }

        public <T> RecordBuilder<T> encode(Item input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            return this.encoder.encode((Object)input, ops, prefix);
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.of(ops.createString("item"), ops.createString("optional"));
        }
    }
}

