/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.json;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public record RandomAttributeModifier(Attribute attribute, AttributeModifier.Operation op, StepFunction value) {
    public static Codec<RandomAttributeModifier> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)BuiltInRegistries.ATTRIBUTE.byNameCodec().fieldOf("attribute").forGetter(a -> a.attribute), (App)PlaceboCodecs.enumCodec(AttributeModifier.Operation.class).fieldOf("operation").forGetter(a -> a.op), (App)StepFunction.CODEC.fieldOf("value").forGetter(a -> a.value)).apply((Applicative)inst, RandomAttributeModifier::new));
    public static Codec<RandomAttributeModifier> CONSTANT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)BuiltInRegistries.ATTRIBUTE.byNameCodec().fieldOf("attribute").forGetter(a -> a.attribute), (App)PlaceboCodecs.enumCodec(AttributeModifier.Operation.class).fieldOf("operation").forGetter(a -> a.op), (App)StepFunction.CONSTANT_CODEC.fieldOf("value").forGetter(a -> a.value)).apply((Applicative)inst, RandomAttributeModifier::new));

    public void apply(RandomSource rand, LivingEntity entity) {
        if (entity == null) {
            throw new RuntimeException("Attempted to apply a random attribute modifier to a null entity!");
        }
        AttributeModifier modif = this.create(rand);
        AttributeInstance inst = entity.getAttribute(this.attribute);
        if (inst == null) {
            Placebo.LOGGER.trace(String.format("Attempted to apply a random attribute modifier to an entity (%s) that does not have that attribute (%s)!", EntityType.getKey((EntityType)entity.getType()), BuiltInRegistries.ATTRIBUTE.getKey((Object)this.attribute)));
            return;
        }
        inst.addPermanentModifier(modif);
    }

    public AttributeModifier create(RandomSource rand) {
        return new AttributeModifier(UUID.randomUUID(), "placebo_random_modifier_" + this.attribute.getDescriptionId(), (double)this.value.get(rand.nextFloat()), this.op);
    }

    public AttributeModifier create(String name, RandomSource rand) {
        return new AttributeModifier(name, (double)this.value.get(rand.nextFloat()), this.op);
    }

    public AttributeModifier createDeterministic() {
        return new AttributeModifier(UUID.randomUUID(), "placebo_random_modifier_" + this.attribute.getDescriptionId(), (double)this.value.min(), this.op);
    }

    public AttributeModifier createDeterministic(String name) {
        return new AttributeModifier(UUID.randomUUID(), name, (double)this.value.min(), this.op);
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public AttributeModifier.Operation getOp() {
        return this.op;
    }

    public StepFunction getValue() {
        return this.value;
    }
}

