/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.loot;

import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.loot.PoolBuilder;
import dev.shadowsoffire.placebo.loot.StackLootEntry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;

public class LootSystem {
    public static final Map<LootDataId<LootTable>, LootTable> PLACEBO_TABLES = new HashMap<LootDataId<LootTable>, LootTable>();

    public static void registerLootTable(ResourceLocation key, LootTable table) {
        LootDataId trueKey = new LootDataId(LootDataType.TABLE, key);
        if (!PLACEBO_TABLES.containsKey(trueKey)) {
            table.setLootTableId(key);
            PLACEBO_TABLES.put((LootDataId<LootTable>)trueKey, table);
        } else {
            Placebo.LOGGER.warn("Duplicate loot entry detected, this is not allowed!  Key: " + key);
        }
    }

    public static LootTable.Builder tableBuilder() {
        return new LootTable.Builder();
    }

    public static PoolBuilder poolBuilder(int minRolls, int maxRolls) {
        return new PoolBuilder(minRolls, maxRolls);
    }

    public static void defaultBlockTable(Block b) {
        LootTable.Builder builder = LootSystem.tableBuilder();
        builder.withPool(LootSystem.poolBuilder(1, 1).addEntries(new LootPoolEntryContainer[]{new StackLootEntry(new ItemStack((ItemLike)b))}).when(ExplosionCondition.survivesExplosion()));
        LootSystem.registerLootTable(new ResourceLocation(BuiltInRegistries.BLOCK.getKey((Object)b).getNamespace(), "blocks/" + BuiltInRegistries.BLOCK.getKey((Object)b).getPath()), builder.build());
    }
}

