/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.placebo.json.ItemAdapter;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class StackLootEntry
extends LootPoolSingletonContainer {
    public static final Codec<StackLootEntry> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ItemAdapter.CODEC.fieldOf("stack").forGetter(e -> e.stack), (App)Codec.intRange((int)0, (int)64).fieldOf("min").forGetter(e -> e.min), (App)Codec.intRange((int)0, (int)64).fieldOf("max").forGetter(e -> e.max)).and(StackLootEntry.singletonFields((RecordCodecBuilder.Instance)inst)).apply((Applicative)inst, StackLootEntry::new));
    public static final LootPoolEntryType TYPE = new LootPoolEntryType(CODEC);
    private final ItemStack stack;
    private final int min;
    private final int max;

    public StackLootEntry(ItemStack stack, int min, int max, int weight, int quality, List<LootItemCondition> conditions, List<LootItemFunction> functions) {
        super(weight, quality, conditions, functions);
        this.stack = stack;
        this.min = min;
        this.max = max;
    }

    public StackLootEntry(ItemStack stack, int min, int max, int weight, int quality) {
        this(stack, min, max, weight, quality, List.of(), List.of());
    }

    public StackLootEntry(ItemLike item, int min, int max, int weight, int quality) {
        this(new ItemStack(item), min, max, weight, quality);
    }

    public StackLootEntry(ItemStack stack) {
        this(stack, 1, 1, 1, 0);
    }

    protected void createItemStack(Consumer<ItemStack> list, LootContext ctx) {
        ItemStack s = this.stack.copy();
        s.setCount(Mth.nextInt((RandomSource)ctx.getRandom(), (int)this.min, (int)this.max));
        list.accept(s);
    }

    public LootPoolEntryType getType() {
        return TYPE;
    }
}

