/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.menu;

import dev.shadowsoffire.placebo.menu.SimplerMenuProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.neoforge.network.IContainerFactory;

public class MenuUtil {
    public static <T extends AbstractContainerMenu> MenuType<T> type(MenuType.MenuSupplier<T> factory) {
        return new MenuType(factory, FeatureFlags.DEFAULT_FLAGS);
    }

    public static <T extends AbstractContainerMenu> MenuType<T> bufType(IContainerFactory<T> factory) {
        return new MenuType(factory, FeatureFlags.DEFAULT_FLAGS);
    }

    public static <T extends AbstractContainerMenu> MenuType<T> posType(PosFactory<T> factory) {
        return new MenuType(MenuUtil.factory(factory), FeatureFlags.DEFAULT_FLAGS);
    }

    public static <M extends AbstractContainerMenu> InteractionResult openGui(Player player, BlockPos pos, PosFactory<M> factory) {
        if (player.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        player.openMenu(new SimplerMenuProvider<M>(player.level(), pos, factory), pos);
        return InteractionResult.CONSUME;
    }

    public static <T extends AbstractContainerMenu> IContainerFactory<T> factory(PosFactory<T> factory) {
        return factory;
    }

    @FunctionalInterface
    public static interface PosFactory<T extends AbstractContainerMenu>
    extends IContainerFactory<T> {
        public T create(int var1, Inventory var2, BlockPos var3);

        default public T create(int id, Inventory inv, FriendlyByteBuf buf) {
            return this.create(id, inv, buf.readBlockPos());
        }
    }
}

