/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.network;

import com.google.common.base.Preconditions;
import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.network.PayloadProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;

public class PayloadHelper {
    private static final Map<ResourceLocation, PayloadProvider<?, ?>> ALL_PROVIDERS = new HashMap();
    private static boolean locked = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends CustomPacketPayload, C extends IPayloadContext> void registerPayload(PayloadProvider<T, C> prov) {
        Preconditions.checkNotNull(prov);
        Map<ResourceLocation, PayloadProvider<?, ?>> map = ALL_PROVIDERS;
        synchronized (map) {
            if (locked) {
                throw new UnsupportedOperationException("Attempted to register a payload provider after registration has finished.");
            }
            if (ALL_PROVIDERS.containsKey(prov.id())) {
                throw new UnsupportedOperationException("Attempted to register payload provider with duplicate ID: " + prov.id());
            }
            ALL_PROVIDERS.put(prov.id(), prov);
        }
    }

    public static void handle(Runnable r, IPayloadContext ctx) {
        ctx.workHandler().execute(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void registerProviders(RegisterPayloadHandlerEvent event) {
        Map<ResourceLocation, PayloadProvider<?, ?>> map = ALL_PROVIDERS;
        synchronized (map) {
            for (PayloadProvider<?, ?> prov : ALL_PROVIDERS.values()) {
                IPayloadRegistrar reg = event.registrar(prov.id().getNamespace());
                if (prov.isOptional()) {
                    reg = reg.optional();
                }
                reg = reg.versioned(prov.getVersion());
                reg.common(prov.id(), prov::read, new PayloadHandler(prov));
            }
            locked = true;
        }
    }

    private static class PayloadHandler<T extends CustomPacketPayload, C extends IPayloadContext>
    implements IPayloadHandler<T> {
        private PayloadProvider<T, C> provider;
        private Optional<PacketFlow> flow;
        private List<ConnectionProtocol> protocols;

        private PayloadHandler(PayloadProvider<T, C> provider) {
            this.provider = provider;
            this.flow = provider.getFlow();
            this.protocols = provider.getSupportedProtocols();
            Preconditions.checkArgument((!this.protocols.isEmpty() ? 1 : 0) != 0, (Object)("The payload registration for " + provider.id() + " must specify at least one valid protocol."));
        }

        public void handle(T payload, IPayloadContext context) {
            if (this.flow.isPresent() && this.flow.get() != context.flow()) {
                Placebo.LOGGER.error("Received a payload {} on the incorrect side.", (Object)payload.id());
                return;
            }
            if (!this.protocols.contains(context.protocol())) {
                Placebo.LOGGER.error("Received a payload {} on the incorrect protocol.", (Object)payload.id());
                return;
            }
            this.provider.handle(payload, context);
        }
    }
}

