/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.packets;

import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.network.PayloadHelper;
import dev.shadowsoffire.placebo.network.PayloadProvider;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class ButtonClickMessage
implements CustomPacketPayload {
    public static final ResourceLocation ID = Placebo.loc("button_click");
    private int button;

    public ButtonClickMessage(int button) {
        this.button = button;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.button);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static class Provider
    implements PayloadProvider<ButtonClickMessage, PlayPayloadContext> {
        @Override
        public ResourceLocation id() {
            return ID;
        }

        @Override
        public ButtonClickMessage read(FriendlyByteBuf buf) {
            return new ButtonClickMessage(buf.readInt());
        }

        @Override
        public void handle(ButtonClickMessage msg, PlayPayloadContext ctx) {
            PayloadHelper.handle(() -> {
                if (((Player)ctx.player().get()).containerMenu instanceof IButtonContainer) {
                    ((IButtonContainer)((Player)ctx.player().get()).containerMenu).onButtonClick(msg.button);
                }
            }, (IPayloadContext)ctx);
        }

        @Override
        public List<ConnectionProtocol> getSupportedProtocols() {
            return List.of(ConnectionProtocol.PLAY);
        }

        @Override
        public Optional<PacketFlow> getFlow() {
            return Optional.of(PacketFlow.SERVERBOUND);
        }
    }

    public static interface IButtonContainer {
        public void onButtonClick(int var1);
    }
}

