/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.patreon.wings;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.shadowsoffire.placebo.patreon.PatreonUtils;
import dev.shadowsoffire.placebo.patreon.WingsManager;
import dev.shadowsoffire.placebo.patreon.wings.IWingModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;

public class Wing
extends EntityModel<AbstractClientPlayer>
implements IWingModel {
    public static Wing INSTANCE;
    private final ModelPart bb_main;
    private final ModelPart cube_r1;
    private final ModelPart cube_r2;

    public Wing(ModelPart baked) {
        this.bb_main = baked.getChild("bb_main");
        this.cube_r1 = this.bb_main.getChild("cube_r1");
        this.cube_r2 = this.bb_main.getChild("cube_r2");
    }

    public void setupAnim(AbstractClientPlayer entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void renderToBuffer(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.bb_main.render(matrixStack, buffer, packedLight, packedOverlay);
    }

    @Override
    public void render(PoseStack stack, MultiBufferSource buf, int packedLightIn, AbstractClientPlayer player, float partialTicks, ResourceLocation texture, PlayerModel<AbstractClientPlayer> model) {
        if (player.isInvisible()) {
            return;
        }
        PatreonUtils.WingType type = WingsManager.getType(player.getUUID());
        stack.translate(0.0, 0.0, 0.065);
        if (player.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof ArmorItem) {
            stack.translate(0.0, 0.0, 0.075);
        }
        stack.mulPose(Axis.YN.rotationDegrees(90.0f));
        float rotationTime = (float)(player.tickCount % 40) + partialTicks;
        this.setRotationAngle(this.cube_r1, 0.0f, 0.52365f + 0.17455f * (float)Math.sin(type.flapSpeed * Math.PI * (double)rotationTime / 20.0), 0.0f);
        this.setRotationAngle(this.cube_r2, 0.0f, -(0.52365f + 0.17455f * (float)Math.sin(type.flapSpeed * Math.PI * (double)rotationTime / 20.0)), 0.0f);
        this.renderToBuffer(stack, buf.getBuffer(RenderType.entityTranslucent((ResourceLocation)texture)), packedLightIn, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.xRot = x;
        modelRenderer.yRot = y;
        modelRenderer.zRot = z;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("bb_main", CubeListBuilder.create().texOffs(0, 0), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.getChild("bb_main").addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, -8.0f, 0.0f, 16.0f, 16.0f, 0.0f, CubeDeformation.NONE.extend(0.001f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)0.0f));
        partdefinition.getChild("bb_main").addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, -8.0f, 0.0f, 16.0f, 16.0f, 0.0f, CubeDeformation.NONE.extend(0.001f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)-0.3491f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }
}

