/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.systems.brewing;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.neoforged.neoforge.common.crafting.NBTIngredient;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;

public class PotionIngredient
extends NBTIngredient {
    public static final Codec<NBTIngredient> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)NeoForgeExtraCodecs.singularOrPluralCodec((Codec)BuiltInRegistries.ITEM.byNameCodec(), (String)"item").forGetter(NBTIngredient::getContainedItems), (App)BuiltInRegistries.POTION.byNameCodec().xmap(PotionIngredient::toTag, PotionIngredient::fromTag).fieldOf("potion").forGetter(NBTIngredient::getTag), (App)Codec.BOOL.optionalFieldOf("strict", (Object)false).forGetter(NBTIngredient::isStrict)).apply((Applicative)builder, PotionIngredient::new));
    public static final Codec<NBTIngredient> CODEC_NONEMPTY = RecordCodecBuilder.create(builder -> builder.group((App)NeoForgeExtraCodecs.singularOrPluralCodecNotEmpty((Codec)BuiltInRegistries.ITEM.byNameCodec(), (String)"item").forGetter(NBTIngredient::getContainedItems), (App)BuiltInRegistries.POTION.byNameCodec().xmap(PotionIngredient::toTag, PotionIngredient::fromTag).fieldOf("potion").forGetter(NBTIngredient::getTag), (App)Codec.BOOL.optionalFieldOf("strict", (Object)false).forGetter(NBTIngredient::isStrict)).apply((Applicative)builder, PotionIngredient::new));

    protected PotionIngredient(Set<Item> items, CompoundTag potion, boolean strict) {
        super(items, potion, null, strict);
    }

    private static CompoundTag toTag(Potion potion) {
        CompoundTag tag = new CompoundTag();
        tag.putString("Potion", BuiltInRegistries.POTION.getKey((Object)potion).toString());
        return tag;
    }

    private static Potion fromTag(CompoundTag tag) {
        ResourceLocation id = new ResourceLocation(tag.getString("Potion"));
        return (Potion)BuiltInRegistries.POTION.get(id);
    }
}

