/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.systems.mixes;

import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import dev.shadowsoffire.placebo.systems.mixes.JsonMix;
import java.util.List;
import net.minecraft.world.item.alchemy.PotionBrewing;

public class MixRegistry
extends DynamicRegistry<JsonMix<?>> {
    public static final MixRegistry INSTANCE = new MixRegistry();

    public MixRegistry() {
        super(Placebo.LOGGER, "brewing_mixes", true, false);
    }

    @Override
    protected void registerBuiltinCodecs() {
        this.registerDefaultCodec(Placebo.loc("mix"), JsonMix.CODEC);
    }

    @Override
    protected void beginReload() {
        this.getValues().forEach(mix -> MixRegistry.getMixList(mix.getMixType()).remove(mix));
        super.beginReload();
    }

    @Override
    protected void onReload() {
        super.onReload();
        this.getValues().forEach(mix -> MixRegistry.getMixList(mix.getMixType()).add(mix));
    }

    private static List getMixList(JsonMix.Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case JsonMix.Type.POTION -> PotionBrewing.POTION_MIXES;
            case JsonMix.Type.CONTAINER -> PotionBrewing.CONTAINER_MIXES;
        };
    }
}

