/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.systems.wanderer;

import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.PlaceboConfig;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import dev.shadowsoffire.placebo.systems.wanderer.BasicWandererTrade;
import dev.shadowsoffire.placebo.systems.wanderer.WandererTrade;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.village.WandererTradesEvent;

@Mod.EventBusSubscriber(modid="placebo", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WandererTradesRegistry
extends DynamicRegistry<WandererTrade> {
    public static final WandererTradesRegistry INSTANCE = new WandererTradesRegistry();
    protected final List<VillagerTrades.ItemListing> normTrades = new ArrayList<VillagerTrades.ItemListing>();
    protected final List<VillagerTrades.ItemListing> rareTrades = new ArrayList<VillagerTrades.ItemListing>();

    public WandererTradesRegistry() {
        super(Placebo.LOGGER, "wanderer_trades", false, true);
    }

    @Override
    protected void registerBuiltinCodecs() {
        this.registerDefaultCodec(Placebo.loc("basic_trade"), BasicWandererTrade.CODEC);
    }

    @Override
    protected void beginReload() {
        super.beginReload();
        this.normTrades.clear();
        this.rareTrades.clear();
    }

    @Override
    protected void onReload() {
        super.onReload();
        this.getValues().forEach(trade -> {
            if (trade.isRare()) {
                this.rareTrades.add((VillagerTrades.ItemListing)trade);
            } else {
                this.normTrades.add((VillagerTrades.ItemListing)trade);
            }
        });
    }

    @SubscribeEvent
    public static void replaceTrades(WandererTradesEvent e) {
        if (PlaceboConfig.clearWandererNormalTrades) {
            e.getGenericTrades().clear();
        }
        if (PlaceboConfig.clearWandererRareTrades) {
            e.getRareTrades().clear();
        }
        e.getGenericTrades().addAll(WandererTradesRegistry.INSTANCE.normTrades);
        e.getRareTrades().addAll(WandererTradesRegistry.INSTANCE.rareTrades);
    }
}

