/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.tabs;

import java.util.function.Supplier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public interface ITabFiller {
    public void fillItemCategory(CreativeModeTab var1, CreativeModeTab.Output var2);

    public static ITabFiller simple(ItemLike i) {
        return (tab, output) -> output.accept(i.asItem().getDefaultInstance());
    }

    public static ITabFiller delegating(Supplier<? extends ItemLike> i) {
        return (tab, output) -> {
            Item item = ((ItemLike)i.get()).asItem();
            if (item instanceof ITabFiller) {
                ITabFiller filler = (ITabFiller)item;
                filler.fillItemCategory(tab, output);
            } else {
                output.accept(item.getDefaultInstance());
            }
        };
    }
}

