/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.util;

import dev.shadowsoffire.placebo.Placebo;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.function.BooleanSupplier;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="placebo", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlaceboTaskQueue {
    private static final Queue<Pair<String, BooleanSupplier>> TASKS = new ArrayDeque<Pair<String, BooleanSupplier>>();

    @SubscribeEvent
    public static void tick(TickEvent.ServerTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            Iterator it = TASKS.iterator();
            Pair current = null;
            while (it.hasNext()) {
                current = (Pair)it.next();
                try {
                    if (!((BooleanSupplier)current.getRight()).getAsBoolean()) continue;
                    it.remove();
                }
                catch (Exception ex) {
                    Placebo.LOGGER.error("An exception occurred while running a ticking task with ID {}.  It will be terminated.", current.getLeft());
                    it.remove();
                    ex.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public static void stopped(ServerStoppedEvent e) {
        TASKS.clear();
    }

    @SubscribeEvent
    public static void started(ServerStartedEvent e) {
        TASKS.clear();
    }

    public static void submitTask(String id, BooleanSupplier task) {
        TASKS.add((Pair<String, BooleanSupplier>)Pair.of((Object)id, (Object)task));
    }
}

