/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.jei;

import com.christofmeg.justenoughbreeding.recipe.BreedingRecipe;
import com.christofmeg.justenoughbreeding.utils.Utils;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class BreedingCategory
implements IRecipeCategory<BreedingRecipe> {
    public static final RecipeType<BreedingRecipe> TYPE = new RecipeType(new ResourceLocation("justenoughbreeding", "breeding"), BreedingRecipe.class);
    final ResourceLocation slotVanilla = new ResourceLocation("jei", "textures/jei/atlas/gui/slot.png");
    final ResourceLocation guiVanilla = new ResourceLocation("jei", "textures/jei/gui/gui_vanilla.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slot;
    private final IDrawable outputSlot;
    private final IDrawable mobRenderSlotTop;
    private final IDrawable mobRenderSlotBottom;
    private final IDrawable mobRenderSlotLeft;
    private final IDrawable mobRenderSlotRight;
    private final IDrawable mobRenderSlotTopCorner;
    private final IDrawable mobRenderSlotTopCenter;

    public BreedingCategory(IGuiHelper helper, ItemLike itemStack) {
        this.background = helper.createBlankDrawable(166, 91);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(itemStack));
        this.slot = helper.drawableBuilder(this.slotVanilla, 0, 0, 18, 18).setTextureSize(18, 18).build();
        this.outputSlot = helper.drawableBuilder(this.guiVanilla, 25, 224, 57, 26).setTextureSize(256, 256).build();
        this.mobRenderSlotTop = helper.drawableBuilder(this.guiVanilla, 56, 128, 25, 1).setTextureSize(256, 256).build();
        this.mobRenderSlotBottom = helper.drawableBuilder(this.guiVanilla, 57, 153, 25, 1).setTextureSize(256, 256).build();
        this.mobRenderSlotLeft = helper.drawableBuilder(this.guiVanilla, 56, 129, 1, 24).setTextureSize(256, 256).build();
        this.mobRenderSlotRight = helper.drawableBuilder(this.guiVanilla, 81, 129, 1, 24).setTextureSize(256, 256).build();
        this.mobRenderSlotTopCorner = helper.drawableBuilder(this.guiVanilla, 81, 128, 1, 1).setTextureSize(256, 256).build();
        this.mobRenderSlotTopCenter = helper.drawableBuilder(this.guiVanilla, 57, 129, 24, 24).setTextureSize(256, 256).build();
    }

    @NotNull
    public RecipeType<BreedingRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"translation.justenoughbreeding.breeding");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BreedingRecipe recipe, @NotNull IFocusGroup focuses) {
        boolean hasOutput;
        builder.addSlot(RecipeIngredientRole.INPUT, 149, 1).addItemStack(recipe.spawnEgg);
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(recipe.spawnEgg);
        int inputX = 74;
        int inputY = 48;
        int extraY = inputY - 10;
        boolean hasExtraInput = recipe.extraInputStack != null && !recipe.extraInputStack.isEmpty();
        boolean bl = hasOutput = recipe.resultItemStack != null && !recipe.resultItemStack.isEmpty();
        if (hasExtraInput && hasOutput) {
            builder.addSlot(RecipeIngredientRole.INPUT, inputX, inputY + 9).addIngredients(recipe.breedingCatalyst);
            builder.addSlot(RecipeIngredientRole.INPUT, inputX, extraY).addIngredients(recipe.extraInputStack);
        } else if (hasExtraInput) {
            builder.addSlot(RecipeIngredientRole.INPUT, inputX + 33, inputY + 9).addIngredients(recipe.breedingCatalyst);
            builder.addSlot(RecipeIngredientRole.INPUT, inputX + 33, extraY).addIngredients(recipe.extraInputStack);
        } else if (!hasOutput) {
            builder.addSlot(RecipeIngredientRole.INPUT, inputX + 33, inputY).addIngredients(recipe.breedingCatalyst);
        } else {
            builder.addSlot(RecipeIngredientRole.INPUT, inputX, inputY).addIngredients(recipe.breedingCatalyst);
        }
        if (hasOutput) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 134, inputY).addIngredients(recipe.resultItemStack);
        }
    }

    public void draw(@NotNull BreedingRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics stack, double mouseX, double mouseY) {
        boolean hasOutput;
        this.slot.draw(stack, 148, 0);
        int inputX = 73;
        int inputY = 47;
        int extraY = inputY - 10;
        boolean hasExtraInput = recipe.extraInputStack != null && !recipe.extraInputStack.isEmpty();
        boolean bl = hasOutput = recipe.resultItemStack != null && !recipe.resultItemStack.isEmpty();
        if (hasExtraInput && hasOutput) {
            this.slot.draw(stack, inputX, inputY + 9);
            this.slot.draw(stack, inputX, extraY);
        } else if (hasExtraInput) {
            this.slot.draw(stack, inputX + 33, inputY + 9);
            this.slot.draw(stack, inputX + 33, extraY);
        } else if (!hasOutput) {
            this.slot.draw(stack, inputX + 33, inputY);
        } else {
            this.slot.draw(stack, inputX, inputY);
        }
        if (hasOutput) {
            this.outputSlot.draw(stack, 98, 43);
        }
        this.mobRenderSlotTop.draw(stack, 0, 10);
        this.mobRenderSlotTop.draw(stack, 25, 10);
        this.mobRenderSlotTop.draw(stack, 35, 10);
        this.mobRenderSlotTopCorner.draw(stack, 60, 10);
        this.mobRenderSlotTopCorner.draw(stack, 0, 90);
        this.mobRenderSlotBottom.draw(stack, 1, 90);
        this.mobRenderSlotBottom.draw(stack, 26, 90);
        this.mobRenderSlotBottom.draw(stack, 36, 90);
        this.mobRenderSlotLeft.draw(stack, 0, 11);
        this.mobRenderSlotLeft.draw(stack, 0, 35);
        this.mobRenderSlotLeft.draw(stack, 0, 59);
        this.mobRenderSlotLeft.draw(stack, 0, 66);
        this.mobRenderSlotRight.draw(stack, 60, 11);
        this.mobRenderSlotRight.draw(stack, 60, 35);
        this.mobRenderSlotRight.draw(stack, 60, 59);
        this.mobRenderSlotRight.draw(stack, 60, 66);
        this.mobRenderSlotTopCenter.draw(stack, 1, 11);
        this.mobRenderSlotTopCenter.draw(stack, 25, 11);
        this.mobRenderSlotTopCenter.draw(stack, 36, 11);
        this.mobRenderSlotTopCenter.draw(stack, 1, 35);
        this.mobRenderSlotTopCenter.draw(stack, 25, 35);
        this.mobRenderSlotTopCenter.draw(stack, 36, 35);
        this.mobRenderSlotTopCenter.draw(stack, 1, 59);
        this.mobRenderSlotTopCenter.draw(stack, 25, 59);
        this.mobRenderSlotTopCenter.draw(stack, 36, 59);
        this.mobRenderSlotTopCenter.draw(stack, 1, 66);
        this.mobRenderSlotTopCenter.draw(stack, 25, 66);
        this.mobRenderSlotTopCenter.draw(stack, 36, 66);
        EntityType<?> entityType = recipe.entityType;
        if (entityType != null) {
            LivingEntity currentLivingEntity;
            Font font = Minecraft.getInstance().font;
            MutableComponent entityName = Component.translatable((String)entityType.getDescriptionId());
            Object entityNameString = entityName.getString();
            if (recipe.needsToBeTamed != null) {
                MutableComponent tamed = Component.translatable((String)"translation.justenoughbreeding.tamed");
                entityNameString = (String)entityNameString + " (" + tamed.getString() + ")";
            } else if (recipe.animalTrusting != null) {
                MutableComponent trusting = Component.translatable((String)"translation.justenoughbreeding.trusting");
                entityNameString = (String)entityNameString + " (" + trusting.getString() + ")";
            }
            int stringWidth = font.width((String)entityNameString);
            int availableWidth = 154;
            if (stringWidth > availableWidth) {
                float pixelWidthPerCharacter = (float)stringWidth / (float)((String)entityNameString).length();
                int maxCharacters = (int)((float)availableWidth / pixelWidthPerCharacter);
                entityNameString = ((String)entityNameString).substring(0, maxCharacters);
            }
            if (!((String)entityNameString).isEmpty()) {
                Component abbreviatedEntityName = Component.nullToEmpty((String)entityNameString);
                stack.drawString(font, abbreviatedEntityName, 0, 0, DyeColor.BLACK.getTextColor(), false);
            }
            if ((currentLivingEntity = recipe.doRendering()) != null) {
                Utils.renderEntity(stack.pose(), mouseX, currentLivingEntity);
            }
        }
    }
}

