/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.recipe;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class BreedingRecipe {
    private LivingEntity currentLivingEntity = null;
    private long lastEntityCreationTime = 0L;
    public final EntityType<?> entityType;
    public final Ingredient breedingCatalyst;
    public final ItemStack spawnEgg;
    @Nullable
    public final Boolean needsToBeTamed;
    public final Ingredient resultItemStack;
    @Nullable
    public final Ingredient extraInputStack;
    @Nullable
    public final Boolean animalTrusting;
    public static final int ENTITY_CREATION_INTERVAL = 3000;

    public BreedingRecipe(EntityType<?> entityType, Ingredient breedingCatalyst, ItemStack spawnEgg, @Nullable Boolean needsToBeTamed, @Nullable Ingredient resultItemStack, @Nullable Ingredient extraInputStack, @Nullable Boolean animalTrusting) {
        this.entityType = entityType;
        this.breedingCatalyst = breedingCatalyst;
        this.spawnEgg = spawnEgg;
        this.needsToBeTamed = needsToBeTamed;
        this.resultItemStack = resultItemStack;
        this.extraInputStack = extraInputStack;
        this.animalTrusting = animalTrusting;
    }

    public LivingEntity doRendering() {
        LivingEntity livingEntity;
        long currentTime = System.currentTimeMillis();
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            if (this.currentLivingEntity == null) {
                this.currentLivingEntity = (LivingEntity)this.entityType.create((Level)level);
                this.lastEntityCreationTime = currentTime;
            }
            if (currentTime - this.lastEntityCreationTime >= 3000L && !ModList.get().isLoaded("entity_model_features") && !ModList.get().isLoaded("optifine")) {
                this.currentLivingEntity = (LivingEntity)this.entityType.create((Level)level);
                this.lastEntityCreationTime = currentTime;
            }
        }
        if (this.currentLivingEntity != null && (livingEntity = this.currentLivingEntity) instanceof TamableAnimal) {
            TamableAnimal tamableAnimal = (TamableAnimal)livingEntity;
            tamableAnimal.setTame(true);
        }
        return this.currentLivingEntity;
    }
}

