/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.rei;

import com.christofmeg.justenoughbreeding.recipe.BreedingRecipe;
import com.christofmeg.justenoughbreeding.rei.BreedingDisplay;
import com.christofmeg.justenoughbreeding.utils.Utils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class BreedingCategoryREI
implements DisplayCategory<BreedingDisplay> {
    public static final CategoryIdentifier<BreedingDisplay> TYPE = CategoryIdentifier.of((String)"justenoughbreeding", (String)"breeding");
    final int inputSlotFrameX = 74;
    final int outputSlotFrameX = 135;
    final int eggSlotX = 154;
    final int eggSlotY = 6;
    final int arrowX = 98;
    final int mobSlotX = 5;
    final int mobSlotY = 15;

    public CategoryIdentifier<? extends BreedingDisplay> getCategoryIdentifier() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"translation.justenoughbreeding.breeding");
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)Items.WHEAT);
    }

    public List<Widget> setupDisplay(BreedingDisplay display, Rectangle bounds) {
        boolean hasOutput;
        LinkedList<Widget> widgets = new LinkedList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add((Widget)Widgets.createSlotBase((Rectangle)new Rectangle(bounds.x + 5, bounds.y + 15, 61, 81)));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(bounds.x + 154, bounds.y + 6)).entries(List.of(EntryStacks.of((ItemStack)display.breedingRecipe.spawnEgg))));
        boolean hasExtraInput = !((EntryStack)display.getExtraInputEntries().get(0).get(0)).isEmpty();
        boolean bl = hasOutput = !((EntryIngredient)display.getOutputEntries().get(0)).isEmpty();
        if (hasExtraInput && hasOutput) {
            widgets.add((Widget)Widgets.createSlot((Point)new Point(bounds.getX() + 74 + 5, bounds.getCenterY() + 10 + 2)).entries((Collection)display.getInputEntries().get(0)));
            widgets.add((Widget)Widgets.createSlot((Point)new Point(bounds.getX() + 74 + 5, bounds.getCenterY() - 9 + 2)).entries((Collection)display.getExtraInputEntries().get(0)));
        } else if (hasExtraInput) {
            widgets.add((Widget)Widgets.createSlot((Point)new Point(bounds.getX() + 74 + 31 + 7, bounds.getCenterY() + 10 + 2)).entries((Collection)display.getInputEntries().get(0)));
            widgets.add((Widget)Widgets.createSlot((Point)new Point(bounds.getX() + 74 + 31 + 7, bounds.getCenterY() - 9 + 2)).entries((Collection)display.getExtraInputEntries().get(0)));
        } else if (!hasOutput) {
            widgets.add((Widget)Widgets.createSlot((Point)new Point(bounds.getX() + 74 + 31 + 7, bounds.getCenterY() + 3)).entries((Collection)display.getInputEntries().get(0)));
        } else {
            widgets.add((Widget)Widgets.createSlot((Point)new Point(bounds.getX() + 74 + 5, bounds.getCenterY() + 3)).entries((Collection)display.getInputEntries().get(0)));
        }
        if (hasOutput) {
            widgets.add((Widget)Widgets.createArrow((Point)new Point(bounds.x + 98 + 4, bounds.getCenterY() + 2)));
            widgets.add(Widgets.createResultSlotBackground((Point)new Point(bounds.x + 135 + 4, bounds.getCenterY() + 3)));
            widgets.add((Widget)Widgets.createSlot((Point)new Point(bounds.x + 135 + 4, bounds.getCenterY() + 3)).entries((Collection)display.getOutputEntries().get(0)).disableBackground().markOutput());
        }
        BreedingRecipe recipe = display.breedingRecipe;
        EntityType<?> entityType = recipe.entityType;
        if (entityType != null) {
            MutableComponent entityName = Component.translatable((String)entityType.getDescriptionId());
            Object entityNameString = entityName.getString();
            if (recipe.needsToBeTamed != null) {
                MutableComponent tamed = Component.translatable((String)"translation.justenoughbreeding.tamed");
                entityNameString = (String)entityNameString + " (" + tamed.getString() + ")";
            } else if (recipe.animalTrusting != null) {
                MutableComponent trusting = Component.translatable((String)"translation.justenoughbreeding.trusting");
                entityNameString = (String)entityNameString + " (" + trusting.getString() + ")";
            }
            int stringWidth = Minecraft.getInstance().font.width((String)entityNameString);
            int availableWidth = 154;
            if (stringWidth > availableWidth) {
                float pixelWidthPerCharacter = (float)stringWidth / (float)((String)entityNameString).length();
                int maxCharacters = (int)((float)availableWidth / pixelWidthPerCharacter);
                entityNameString = ((String)entityNameString).substring(0, maxCharacters);
            }
            if (!((String)entityNameString).isEmpty()) {
                Component abbreviatedEntityName = Component.nullToEmpty((String)entityNameString);
                widgets.add((Widget)Widgets.createLabel((Point)new Point(bounds.x + 5, bounds.y + 5), (Component)abbreviatedEntityName).noShadow().leftAligned().color(-12566464, -4473925));
            }
            widgets.add((Widget)Widgets.withTranslate((Widget)Widgets.createDrawableWidget((stack, mouseX, mouseY, v) -> {
                LivingEntity currentLivingEntity = recipe.doRendering();
                if (currentLivingEntity != null) {
                    Utils.renderEntity(stack.pose(), mouseX, currentLivingEntity);
                }
            }), (double)(bounds.x + 5), (double)(bounds.y + 15 - 10), (double)0.0));
        }
        return widgets;
    }

    public int getDisplayWidth(BreedingDisplay breedingDisplay) {
        return 176;
    }

    public int getDisplayHeight() {
        return 101;
    }
}

