/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.trimeffects;

import com.mojang.serialization.DynamicOps;
import dev.foxgirl.trimeffects.Config;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TrimEffects {
    public static final Logger LOGGER = LogManager.getLogger((String)"trimeffects");
    private static TrimEffects INSTANCE;
    private Config.Parsed config;
    private final Map<UUID, AbsorptionRecord> absorptionRecords = new HashMap<UUID, AbsorptionRecord>();

    @NotNull
    public static TrimEffects getInstance() {
        return INSTANCE;
    }

    @NotNull
    public static TrimEffects createInstance() {
        return new TrimEffects();
    }

    private TrimEffects() {
        INSTANCE = this;
    }

    @NotNull
    public Config.Parsed getConfig() {
        return Objects.requireNonNull(this.config, "Expression 'config'");
    }

    public void initialize(@NotNull Path configDirectory) {
        this.config = Config.read(configDirectory).parse();
    }

    @NotNull
    public static RegistryAccess getRegistryManager(@NotNull Entity entity) {
        return entity.level().registryAccess();
    }

    @NotNull
    public static <T> ResourceKey<T> getKey(@NotNull Holder<T> entry) {
        return (ResourceKey)entry.unwrapKey().orElseThrow();
    }

    @Nullable
    public static ArmorTrim getTrim(@NotNull RegistryAccess manager, @NotNull ItemStack stack) {
        CompoundTag nbt = stack.getTagElement("Trim");
        if (nbt == null || !stack.is(ItemTags.TRIMMABLE_ARMOR)) {
            return null;
        }
        return ArmorTrim.CODEC.parse((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)manager), (Object)nbt).result().orElse(null);
    }

    public void handleTick(LivingEntity player) {
        RegistryAccess manager = TrimEffects.getRegistryManager((Entity)player);
        List armor = (List)player.getArmorSlots();
        Trim[] trims = new Trim[armor.size()];
        int length = trims.length;
        for (int i = 0; i < length; ++i) {
            trims[i] = Trim.from(manager, (ItemStack)armor.get(i));
        }
        for (Trim trim : trims) {
            int count;
            if (trim == null || (!this.getConfig().isEnableCombinedEffects() ? Arrays.stream(trims).anyMatch(t -> t != null && !trim.equals(t)) : Arrays.stream(trims).anyMatch(t -> t != null && !trim.equals(t) && trim.getPattern().equals(t.getPattern()))) || (count = (int)Arrays.stream(trims).filter(t -> Objects.equals(t, trim)).count()) < this.getConfig().getMinimumMatchingTrims()) continue;
            this.handleTickForTrim(player, trim);
        }
    }

    private void handleTickForTrim(LivingEntity player, Trim trim) {
        RegistryAccess manager = TrimEffects.getRegistryManager((Entity)player);
        ResourceKey<TrimPattern> pattern = TrimEffects.getKey(trim.getPattern());
        ResourceKey<TrimMaterial> material = TrimEffects.getKey(trim.getMaterial());
        ResourceKey<MobEffect> effect = this.getConfig().getEffects().get(pattern);
        Integer strength = this.getConfig().getStrengths().get(material);
        int durationMaximum = (int)((this.getConfig().getSecondsMaximum() + 0.75) * 20.0);
        int durationMinimum = (int)((this.getConfig().getSecondsMinimum() + 0.75) * 20.0);
        if (effect != null && strength != null && strength > 0) {
            MobEffectInstance effectInstance;
            int amplifier = strength - 1;
            MobEffect effectType = (MobEffect)manager.registryOrThrow(Registries.MOB_EFFECT).get(effect);
            if (effectType != null && ((effectInstance = player.getEffect(effectType)) == null || effectInstance.getAmplifier() < amplifier || effectInstance.endsWithin(durationMinimum))) {
                if (effectType == MobEffects.ABSORPTION) {
                    AbsorptionRecord absorptionRecord = this.absorptionRecords.computeIfAbsent(player.getUUID(), uuid -> new AbsorptionRecord(player));
                    float currentAbsorptionAmount = player.getAbsorptionAmount();
                    float previousAbsorptionAmount = absorptionRecord.previousAmount;
                    absorptionRecord.previousAmount = currentAbsorptionAmount;
                    if (absorptionRecord.stunTicks > 0) {
                        --absorptionRecord.stunTicks;
                        return;
                    }
                    if (effectInstance != null && currentAbsorptionAmount < previousAbsorptionAmount) {
                        absorptionRecord.stunTicks = (int)(this.getConfig().getAbsorptionStunSeconds() * 20.0);
                        return;
                    }
                }
                if (effectType == MobEffects.REGENERATION && effectInstance != null && !effectInstance.endsWithin(50) && player.getHealth() < player.getMaxHealth()) {
                    return;
                }
                player.addEffect(new MobEffectInstance(effectType, durationMaximum, amplifier), (Entity)player);
            }
        }
    }

    private record Trim(@NotNull ArmorTrim trim) {
        private static Trim from(@NotNull RegistryAccess manager, @NotNull ItemStack stack) {
            ArmorTrim trim = TrimEffects.getTrim(manager, stack);
            return trim == null ? null : new Trim(trim);
        }

        @NotNull
        private Holder<TrimPattern> getPattern() {
            return this.trim.pattern();
        }

        @NotNull
        private Holder<TrimMaterial> getMaterial() {
            return this.trim.material();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Trim that = (Trim)obj;
            return Objects.equals(this.getPattern(), that.getPattern()) && Objects.equals(this.getMaterial(), that.getMaterial());
        }
    }

    private static final class AbsorptionRecord {
        private float previousAmount;
        private int stunTicks;

        private AbsorptionRecord(LivingEntity player) {
            this.previousAmount = player.getAbsorptionAmount();
            this.stunTicks = 0;
        }
    }
}

