/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.trimeffects.mixin;

import dev.foxgirl.trimeffects.Config;
import dev.foxgirl.trimeffects.TrimEffects;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ArmorTrim.class})
public abstract class MixinArmorTrim {
    @Inject(method={"appendUpgradeHoverText(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/core/RegistryAccess;Ljava/util/List;)V"}, at={@At(value="TAIL")})
    private static void trimeffects$afterAppendTooltip(ItemStack stack, RegistryAccess manager, List<Component> tooltip, CallbackInfo info) {
        ArmorTrim trim = TrimEffects.getTrim(manager, stack);
        if (trim != null) {
            MobEffect effectType;
            Config.Parsed config = TrimEffects.getInstance().getConfig();
            Holder pattern = trim.pattern();
            Holder material = trim.material();
            ResourceKey<MobEffect> effect = config.getEffects().get(TrimEffects.getKey(pattern));
            Integer strength = config.getStrengths().get(TrimEffects.getKey(material));
            if (effect != null && strength != null && strength > 0 && (effectType = (MobEffect)manager.registryOrThrow(Registries.MOB_EFFECT).get(effect)) != null) {
                MutableComponent text = CommonComponents.space().append(effectType.getDisplayName());
                if (strength > 1) {
                    text.append(CommonComponents.SPACE);
                    if (strength <= 10) {
                        text.append((Component)Component.translatable((String)("enchantment.level." + strength)));
                    } else {
                        text.append(strength.toString());
                    }
                }
                tooltip.add((Component)text.withStyle(((TrimMaterial)material.value()).description().getStyle()));
            }
        }
    }
}

