/*
 * Decompiled with CFR 0.152.
 */
package giselle.jei_mekanism_multiblocks.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import giselle.jei_mekanism_multiblocks.client.GuiHelper;
import giselle.jei_mekanism_multiblocks.client.gui.TextAlignment;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class ButtonWidget
extends AbstractButton {
    private final List<IPressHandler> pressHandlers = new ArrayList<IPressHandler>();

    public ButtonWidget(int pX, int pY, int pWidth, int pHeight, Component pMessage) {
        super(pX, pY, pWidth, pHeight, pMessage);
    }

    public void addPressHandler(IPressHandler handler) {
        this.pressHandlers.add(handler);
    }

    public void onPress() {
        for (IPressHandler handler : this.pressHandlers) {
            handler.onPress(this);
        }
    }

    public void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        GuiHelper.blitButton(pGuiGraphics, this.getX(), this.getY(), this.width, this.height, this.active, this.isHoveredOrFocused());
        int j = this.getFGColor();
        GuiHelper.drawScaledText(pGuiGraphics, this.getMessage(), this.getX(), this.getY() + (this.height - 8) / 2, this.width, j | Mth.ceil((float)(this.alpha * 255.0f)) << 24, true, TextAlignment.CENTER);
    }

    protected void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
        this.defaultButtonNarrationText(pNarrationElementOutput);
    }

    public static interface IPressHandler {
        public void onPress(AbstractButton var1);
    }
}

