/*
 * Decompiled with CFR 0.152.
 */
package giselle.jei_mekanism_multiblocks.common.util;

import giselle.jei_mekanism_multiblocks.common.util.VolumeUnit;
import java.util.HashMap;
import java.util.Map;
import mekanism.common.util.text.TextUtils;
import net.minecraft.network.chat.Component;

public class VolumeTextHelper {
    private static final Map<Integer, VolumeUnit> MULTIPLIER_TO_UNIT = new HashMap<Integer, VolumeUnit>();

    public static Component formatMB(double value) {
        return VolumeTextHelper.format(value, VolumeUnit.MILLI, "B");
    }

    public static Component formatMBt(double value) {
        return VolumeTextHelper.format(value, VolumeUnit.MILLI, "B/t");
    }

    public static Component format(double value, VolumeUnit from, String unit) {
        return VolumeTextHelper.format(value, from, unit, 3);
    }

    public static Component format(double value, VolumeUnit from, String unit, int decimals) {
        VolumeUnit next;
        double remain;
        VolumeUnit to = from;
        int multiplier = from.getMultiplier();
        for (remain = value; remain >= 1000.0 && (next = MULTIPLIER_TO_UNIT.get(multiplier + 1)) != null; remain /= 1000.0) {
            ++multiplier;
            to = next;
        }
        String text = TextUtils.format((double)remain);
        if (multiplier > -1) {
            int currentDecimals;
            int decimalIndex = text.indexOf(46);
            boolean hasDecimalPart = decimalIndex > -1;
            String exponentialPart = hasDecimalPart ? text.substring(0, decimalIndex) : text;
            Object deciamlPart = hasDecimalPart ? text.substring(decimalIndex + 1) : "";
            int n = currentDecimals = hasDecimalPart ? ((String)deciamlPart).length() : 0;
            if (currentDecimals > decimals) {
                deciamlPart = ((String)deciamlPart).substring(0, decimals);
            } else if (currentDecimals < decimals) {
                StringBuilder zero = new StringBuilder();
                for (int i = 0; i < decimals - currentDecimals; ++i) {
                    zero.append('0');
                }
                deciamlPart = (String)deciamlPart + zero;
            }
            text = exponentialPart + "." + (String)deciamlPart;
        }
        return Component.literal((String)(text + " " + to.getShortName() + unit));
    }

    private VolumeTextHelper() {
    }

    static {
        for (VolumeUnit unit : VolumeUnit.values()) {
            MULTIPLIER_TO_UNIT.put(unit.getMultiplier(), unit);
        }
    }
}

