/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Map;
import me.wesley1808.servercore.common.config.Config;
import me.wesley1808.servercore.common.config.data.CommandConfig;
import me.wesley1808.servercore.common.dynamic.DynamicManager;
import me.wesley1808.servercore.common.services.Formatter;
import me.wesley1808.servercore.common.services.Permission;
import me.wesley1808.servercore.common.utils.Util;
import me.wesley1808.servercore.common.utils.statistics.GroupBy;
import me.wesley1808.servercore.common.utils.statistics.StatisticType;
import me.wesley1808.servercore.common.utils.statistics.Statistics;
import me.wesley1808.servercore.common.utils.statistics.entry.StatisticEntry;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import org.jetbrains.annotations.Nullable;

public class StatisticsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder statistics = (LiteralArgumentBuilder)Commands.literal((String)"statistics").requires(Permission.require("command.statistics", 2));
        statistics.executes(ctx -> StatisticsCommand.displayOverview((CommandSourceStack)ctx.getSource()));
        for (StatisticType type : StatisticType.values()) {
            statistics.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)type.getCommandFormat()).executes(ctx -> StatisticsCommand.display((CommandContext<CommandSourceStack>)ctx, type, 1))).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> StatisticsCommand.display((CommandContext<CommandSourceStack>)ctx, type, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"byType").executes(ctx -> StatisticsCommand.display((CommandContext<CommandSourceStack>)ctx, type, GroupBy.TYPE, 1))).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> StatisticsCommand.display((CommandContext<CommandSourceStack>)ctx, type, GroupBy.TYPE, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"))))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ctx -> StatisticsCommand.display((CommandContext<CommandSourceStack>)ctx, type, 1, EntityArgument.getPlayer((CommandContext)ctx, (String)"player")))).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> StatisticsCommand.display((CommandContext<CommandSourceStack>)ctx, type, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"), EntityArgument.getPlayer((CommandContext)ctx, (String)"player"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"byPlayer").executes(ctx -> StatisticsCommand.display((CommandContext<CommandSourceStack>)ctx, type, GroupBy.PLAYER, 1))).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> StatisticsCommand.display((CommandContext<CommandSourceStack>)ctx, type, GroupBy.PLAYER, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"))))));
        }
        dispatcher.register(statistics);
    }

    private static int displayOverview(CommandSourceStack source) {
        Statistics statistics = Statistics.getInstance(source.getServer());
        CommandConfig config = Config.get().commands();
        source.sendSuccess(() -> {
            MutableComponent component = Component.empty();
            MutableComponent title = Component.literal((String)"Statistics").withColor(config.tertiaryValue());
            if (source.isPlayer()) {
                Formatter.addLines(component, 16, config.primaryValue(), (Component)title);
            } else {
                component.append((Component)title);
            }
            double mspt = DynamicManager.getInstance(source.getServer()).getAverageTickTime();
            double tps = mspt != 0.0 ? Math.min(1000.0 / mspt, 20.0) : 20.0;
            component.append(Formatter.parse("\n<dark_gray>\u00bb <c:#primary>TPS: <c:#secondary>%.2f</c> - MSPT: <c:#secondary>%.2f".formatted(tps, mspt)));
            component.append(Formatter.parse("\n<dark_gray>\u00bb <c:#primary>Total chunk count: <c:#secondary>%d".formatted(statistics.getChunkCount(true))));
            component.append(Formatter.parse("\n<dark_gray>\u00bb <c:#primary>Total entity count: <c:#secondary>%d".formatted(statistics.getAllEntities().size())));
            component.append(Formatter.parse("\n<dark_gray>\u00bb <c:#primary>Total block entity count: <c:#secondary>%d".formatted(statistics.getAllBlockEntities().size())));
            return component;
        }, false);
        return 1;
    }

    private static int display(CommandContext<CommandSourceStack> context, StatisticType type, int page) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player != null) {
            return StatisticsCommand.display(context, type, GroupBy.TYPE, page, player);
        }
        return StatisticsCommand.display(context, type, GroupBy.TYPE, page);
    }

    private static int display(CommandContext<CommandSourceStack> context, StatisticType type, GroupBy groupBy, int page) {
        return StatisticsCommand.display(context, type, groupBy, page, null);
    }

    private static int display(CommandContext<CommandSourceStack> context, StatisticType type, int page, @Nullable ServerPlayer player) {
        return StatisticsCommand.display(context, type, GroupBy.TYPE, page, player);
    }

    private static int display(CommandContext<CommandSourceStack> context, StatisticType type, GroupBy groupBy, int page, @Nullable ServerPlayer player) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case StatisticType.ENTITY -> StatisticsCommand.displayEntities(context, groupBy, page, player);
            case StatisticType.BLOCK_ENTITY -> StatisticsCommand.displayBlockEntities(context, groupBy, page, player);
        };
    }

    private static int displayEntities(CommandContext<CommandSourceStack> context, GroupBy groupBy, int page, @Nullable ServerPlayer player) {
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        Statistics statistics = Statistics.getInstance(server);
        Map<String, StatisticEntry<Entity>> map = groupBy == GroupBy.PLAYER ? statistics.getEntitiesByPlayer(server.getPlayerList().getPlayers()) : statistics.getEntitiesByType(player == null ? statistics.getAllEntities() : statistics.getEntitiesNear(player));
        StatisticsCommand.displayFeedback(context, Util.sortByValue(map), StatisticType.ENTITY, groupBy, page, player);
        return 1;
    }

    private static int displayBlockEntities(CommandContext<CommandSourceStack> context, GroupBy groupBy, int page, @Nullable ServerPlayer player) {
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        Statistics statistics = Statistics.getInstance(server);
        Map<String, StatisticEntry<TickingBlockEntity>> map = groupBy == GroupBy.PLAYER ? statistics.getBlockEntitiesByPlayer(server.getPlayerList().getPlayers()) : statistics.getBlockEntitiesByType(player == null ? statistics.getAllBlockEntities() : statistics.getBlockEntitiesNear(player));
        StatisticsCommand.displayFeedback(context, Util.sortByValue(map), StatisticType.BLOCK_ENTITY, groupBy, page, player);
        return 1;
    }

    private static <T> void displayFeedback(CommandContext<CommandSourceStack> context, List<Map.Entry<String, StatisticEntry<T>>> formattedEntries, StatisticType type, GroupBy groupBy, int page, @Nullable ServerPlayer player) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        MutableComponent component = Component.empty();
        CommandConfig config = Config.get().commands();
        component.append(StatisticsCommand.createHeader(type, groupBy, source, player, config));
        boolean success = Util.iteratePage(formattedEntries, page, 8, (entry, index) -> component.append(StatisticsCommand.createEntry(entry, index, type, groupBy, config)));
        if (success) {
            source.sendSuccess(() -> component.append(StatisticsCommand.createFooter(page, Util.getPage(formattedEntries.size(), 8), type, context, config)), false);
        } else if (page == 1) {
            source.sendFailure((Component)Component.literal((String)String.format("No %s were found!", type.getName().toLowerCase())));
        } else {
            source.sendFailure((Component)Component.literal((String)"Page doesn't exist!"));
        }
    }

    private static <T> Component createEntry(Map.Entry<String, StatisticEntry<T>> entry, int index, StatisticType type, GroupBy groupBy, CommandConfig config) {
        MutableComponent component = Component.empty();
        component.append(Formatter.parse("\n<c:#secondary>%d. <c:#primary>%s %s".formatted(index, entry.getKey(), entry.getValue().formatValue())));
        if (groupBy == GroupBy.PLAYER) {
            component.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/statistics %s byType %s".formatted(type.getCommandFormat(), entry.getKey()))));
        }
        return component;
    }

    private static Component createHeader(StatisticType type, GroupBy groupBy, CommandSourceStack source, ServerPlayer player, CommandConfig config) {
        MutableComponent component = Component.empty();
        Component title = player == null ? Formatter.parse("<c:#primary><c:#tertiary>%s</c> by <c:#tertiary>%s".formatted(type.getName(), groupBy.getName())) : Formatter.parse("<c:#primary><c:#tertiary>%s</c> for <c:#tertiary>%s".formatted(type.getName(), player.getScoreboardName()));
        if (source.isPlayer()) {
            Formatter.addLines(component, 16, config.primaryValue(), title);
        } else {
            component.append(title);
        }
        return component;
    }

    private static Component createFooter(int page, int pageCount, StatisticType type, CommandContext<CommandSourceStack> context, CommandConfig config) {
        MutableComponent component = Component.literal((String)"\n");
        MutableComponent footer = Component.empty();
        String command = StatisticsCommand.parseCommand(context.getInput());
        MutableComponent prevPage = Component.literal((String)"<<").withColor(config.secondaryValue());
        if (page > 1) {
            prevPage.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command.replace("%page_nr%", String.valueOf(page - 1)))));
        }
        MutableComponent nextPage = Component.literal((String)">>").withColor(config.secondaryValue());
        nextPage.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command.replace("%page_nr%", String.valueOf(page + 1)))));
        footer.append((Component)prevPage);
        footer.append(Formatter.parse(" <c:#primary>Page <c:#tertiary>%d</c> of <c:#tertiary>%d ".formatted(page, pageCount)));
        footer.append((Component)nextPage);
        if (((CommandSourceStack)context.getSource()).isPlayer()) {
            Formatter.addLines(component, type == StatisticType.BLOCK_ENTITY ? 20 : 16, config.primaryValue(), (Component)footer);
        } else {
            component.append((Component)footer);
        }
        return component;
    }

    private static String parseCommand(String input) {
        Object command = input.replaceAll("\\b\\d+\\b", "%page_nr%");
        if (!((String)command).contains("%page_nr%")) {
            command = (String)command + " %page_nr%";
        }
        return "/" + (String)command;
    }
}

