/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.config.data.breeding_cap;

import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import space.arim.dazzleconf.annote.ConfDefault;
import space.arim.dazzleconf.annote.ConfKey;
import space.arim.dazzleconf.annote.IntegerRange;
import space.arim.dazzleconf.sorter.AnnotationBasedSorter;

public interface BreedingCap {
    public static final Map<EntityType<?>, Set<EntityType<?>>> CUSTOM_TYPES = Map.of(EntityType.FROG, Set.of(EntityType.TADPOLE, EntityType.FROG));

    @AnnotationBasedSorter.Order(value=1)
    @ConfKey(value="limit")
    @ConfDefault.DefaultInteger(value=32)
    public int limit();

    @AnnotationBasedSorter.Order(value=2)
    @ConfKey(value="range")
    @ConfDefault.DefaultInteger(value=64)
    @IntegerRange(min=1L)
    public int range();

    default public boolean exceedsLimit(EntityType<?> type, Level level, BlockPos pos) {
        int limit = this.limit();
        if (limit < 0) {
            return false;
        }
        AABB area = this.getAreaAt(pos);
        Set<EntityType<?>> set = CUSTOM_TYPES.get(type);
        int count = set != null && !set.isEmpty() ? level.getEntities((Entity)null, area, entity -> set.contains(entity.getType())).size() : level.getEntities(type, area, EntitySelector.NO_SPECTATORS).size();
        return limit <= count;
    }

    default public boolean exceedsLimit(Entity entity) {
        return this.exceedsLimit(entity.getType(), entity.level(), entity.blockPosition());
    }

    private AABB getAreaAt(BlockPos pos) {
        int range = this.range();
        return AABB.encapsulatingFullBlocks((BlockPos)pos.offset(range, range, range), (BlockPos)pos.offset(-range, -range, -range));
    }

    public static void resetLove(Animal owner, Animal mate) {
        BreedingCap.resetAge((AgeableMob)owner, (AgeableMob)mate);
        owner.resetLove();
        mate.resetLove();
    }

    public static void resetAge(AgeableMob owner, AgeableMob mate) {
        owner.setAge(6000);
        mate.setAge(6000);
    }
}

