/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import rzk.wirelessredstone.block.RedstoneTransceiverBlock;
import rzk.wirelessredstone.block.entity.RedstoneReceiverBlockEntity;
import rzk.wirelessredstone.ether.RedstoneEther;
import rzk.wirelessredstone.misc.WRConfig;

public class RedstoneReceiverBlock
extends RedstoneTransceiverBlock {
    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!world.isClientSide && WRConfig.redstoneReceiverStrongPower) {
            for (Direction direction : UPDATE_SHAPE_ORDER) {
                world.updateNeighborsAtExceptFromFacing(pos.relative(direction), (Block)this, direction.getOpposite());
            }
        }
        super.onRemove(state, world, pos, newState, moved);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        RedstoneEther ether = RedstoneEther.getOrCreate(world);
        boolean powered = ether.isFrequencyActive(this.getFrequency((Level)world, pos));
        if ((Boolean)state.getValue((Property)BlockStateProperties.POWERED) != powered) {
            world.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        }
    }

    public int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return (Boolean)state.getValue((Property)BlockStateProperties.POWERED) != false && this.connectsToRedstone(state, world, pos, direction) ? WRConfig.redstoneReceiverSignalStrength : 0;
    }

    public int getDirectSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return WRConfig.redstoneReceiverStrongPower ? this.getSignal(state, world, pos, direction) : 0;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RedstoneReceiverBlockEntity(pos, state);
    }
}

