/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.block;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import rzk.wirelessredstone.WirelessRedstone;
import rzk.wirelessredstone.api.RedstoneConnectable;
import rzk.wirelessredstone.block.entity.RedstoneTransceiverBlockEntity;
import rzk.wirelessredstone.item.FrequencyItem;
import rzk.wirelessredstone.misc.WRUtils;

public abstract class RedstoneTransceiverBlock
extends Block
implements EntityBlock,
RedstoneConnectable {
    public RedstoneTransceiverBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).isRedstoneConductor((state, blockGetter, pos) -> false).strength(1.5f, 5.0f).sound(SoundType.METAL));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void setFrequency(Level world, BlockPos pos, int frequency) {
        BlockEntity blockEntity;
        if (WRUtils.isValidFrequency(frequency) && (blockEntity = world.getBlockEntity(pos)) instanceof RedstoneTransceiverBlockEntity) {
            RedstoneTransceiverBlockEntity transceiver = (RedstoneTransceiverBlockEntity)blockEntity;
            transceiver.setFrequency(frequency);
        }
    }

    public int getFrequency(Level world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof RedstoneTransceiverBlockEntity) {
            RedstoneTransceiverBlockEntity transceiver = (RedstoneTransceiverBlockEntity)blockEntity;
            return transceiver.getFrequency();
        }
        return 0;
    }

    @Override
    public boolean connectsToRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return true;
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Item item = player.getItemInHand(hand).getItem();
        if (item instanceof FrequencyItem) {
            return InteractionResult.PASS;
        }
        if (!world.isClientSide) {
            WirelessRedstone.PLATFORM.sendFrequencyBlockPacket((ServerPlayer)player, this.getFrequency(world, pos), pos);
        }
        return InteractionResult.SUCCESS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.POWERED});
    }

    public void appendHoverText(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag options) {
        int frequency = WRUtils.readFrequency(BlockItem.getBlockEntityData((ItemStack)stack));
        if (!WRUtils.isValidFrequency(frequency)) {
            return;
        }
        MutableComponent frequencyComponent = Component.literal((String)String.valueOf(frequency)).withStyle(ChatFormatting.AQUA);
        tooltip.add((Component)Component.translatable((String)"item.wirelessredstone.tooltip.frequency", (Object[])new Object[]{frequencyComponent}).withStyle(ChatFormatting.GRAY));
    }
}

