/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import rzk.wirelessredstone.block.RedstoneTransceiverBlock;
import rzk.wirelessredstone.block.entity.RedstoneTransmitterBlockEntity;
import rzk.wirelessredstone.registry.ModBlockEntities;

public class RedstoneTransmitterBlock
extends RedstoneTransceiverBlock {
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        BlockState state = this.defaultBlockState();
        return (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(this.isReceivingRedstonePower(state, (LevelAccessor)world, pos)));
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        world.getBlockEntity(pos, ModBlockEntities.redstoneTransmitterBlockEntityType).ifPresent(entity -> entity.onBlockPlaced(state, world, pos));
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        world.getBlockEntity(pos, ModBlockEntities.redstoneTransmitterBlockEntityType).ifPresent(entity -> entity.onBlockRemoved(state, world, pos));
        super.onRemove(state, world, pos, newState, moved);
    }

    private boolean isReceivingRedstonePower(BlockState state, LevelAccessor world, BlockPos pos) {
        for (Direction side : UPDATE_SHAPE_ORDER) {
            if (!this.connectsToRedstone(state, (BlockGetter)world, pos, side) || !world.hasSignal(pos.relative(side), side)) continue;
            return true;
        }
        return false;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (world.isClientSide) {
            return;
        }
        boolean powered = this.isReceivingRedstonePower(state, (LevelAccessor)world, pos);
        if ((Boolean)state.getValue((Property)BlockStateProperties.POWERED) == powered) {
            return;
        }
        world.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(powered)), 2);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RedstoneTransmitterBlockEntity(pos, state);
    }
}

