/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import rzk.wirelessredstone.block.entity.RedstoneTransceiverBlockEntity;
import rzk.wirelessredstone.ether.RedstoneEther;
import rzk.wirelessredstone.misc.WRUtils;
import rzk.wirelessredstone.registry.ModBlockEntities;

public class RedstoneReceiverBlockEntity
extends RedstoneTransceiverBlockEntity {
    public RedstoneReceiverBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.redstoneReceiverBlockEntityType, pos, state);
    }

    @Override
    protected void onFrequencyChange(int oldFrequency, int newFrequency) {
        if (this.level.isClientSide) {
            return;
        }
        RedstoneEther ether = RedstoneEther.getOrCreate((ServerLevel)this.level);
        ether.removeReceiver(this.worldPosition, oldFrequency);
        if (WRUtils.isValidFrequency(newFrequency)) {
            ether.addReceiver(this.level, this.worldPosition, newFrequency);
        }
    }

    public void setLevel(Level world) {
        super.setLevel(world);
        if (world.isClientSide) {
            return;
        }
        world.getServer().tell((Runnable)new TickTask(1, () -> {
            RedstoneEther ether = RedstoneEther.getOrCreate((ServerLevel)world);
            ether.addReceiver(world, this.worldPosition, this.frequency);
        }));
    }

    public void setRemoved() {
        if (!this.level.isClientSide) {
            RedstoneEther ether = RedstoneEther.getOrCreate((ServerLevel)this.level);
            ether.removeReceiver(this.worldPosition, this.frequency);
        }
        super.setRemoved();
    }
}

