/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import rzk.wirelessredstone.misc.WRUtils;

public abstract class RedstoneTransceiverBlockEntity
extends BlockEntity {
    protected int frequency = -1;

    public RedstoneTransceiverBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    protected abstract void onFrequencyChange(int var1, int var2);

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        if (frequency == this.frequency) {
            return;
        }
        this.onFrequencyChange(this.frequency, frequency);
        this.frequency = frequency;
        this.setChanged();
        BlockState state = this.getBlockState();
        this.level.sendBlockUpdated(this.worldPosition, state, state, 2);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag() {
        CompoundTag nbt = new CompoundTag();
        WRUtils.writeFrequency(nbt, this.frequency);
        return nbt;
    }

    public void load(CompoundTag nbt) {
        super.load(nbt);
        this.frequency = WRUtils.readFrequency(nbt);
    }

    protected void saveAdditional(CompoundTag nbt) {
        super.saveAdditional(nbt);
        WRUtils.writeFrequency(nbt, this.frequency);
    }
}

