/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import rzk.wirelessredstone.block.entity.RedstoneTransceiverBlockEntity;
import rzk.wirelessredstone.ether.RedstoneEther;
import rzk.wirelessredstone.misc.WRUtils;
import rzk.wirelessredstone.registry.ModBlockEntities;

public class RedstoneTransmitterBlockEntity
extends RedstoneTransceiverBlockEntity {
    public RedstoneTransmitterBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.redstoneTransmitterBlockEntityType, pos, state);
    }

    @Override
    protected void onFrequencyChange(int oldFrequency, int newFrequency) {
        if (this.level.isClientSide || !((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.POWERED)).booleanValue()) {
            return;
        }
        RedstoneEther ether = RedstoneEther.getOrCreate((ServerLevel)this.level);
        ether.removeTransmitter(this.level, this.worldPosition, oldFrequency);
        if (WRUtils.isValidFrequency(newFrequency)) {
            ether.addTransmitter(this.level, this.worldPosition, newFrequency);
        }
    }

    public void onBlockPlaced(BlockState state, Level world, BlockPos pos) {
        if (world.isClientSide || !((Boolean)state.getValue((Property)BlockStateProperties.POWERED)).booleanValue() || !WRUtils.isValidFrequency(this.frequency)) {
            return;
        }
        RedstoneEther ether = RedstoneEther.getOrCreate((ServerLevel)world);
        ether.addTransmitter(world, pos, this.frequency);
    }

    public void onBlockRemoved(BlockState state, Level world, BlockPos pos) {
        if (world.isClientSide || !((Boolean)state.getValue((Property)BlockStateProperties.POWERED)).booleanValue() || !WRUtils.isValidFrequency(this.frequency)) {
            return;
        }
        RedstoneEther ether = RedstoneEther.getOrCreate((ServerLevel)world);
        ether.removeTransmitter(world, pos, this.frequency);
    }
}

