/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.ether;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import rzk.wirelessredstone.misc.WRUtils;
import rzk.wirelessredstone.registry.ModBlocks;

public class RedstoneChannel {
    private final int frequency;
    private final Set<BlockPos> transmitters = new HashSet<BlockPos>();
    private final Set<BlockPos> receivers = new HashSet<BlockPos>();
    private final Set<LivingEntity> remotes = new HashSet<LivingEntity>();

    public RedstoneChannel(int frequency) {
        this.frequency = frequency;
    }

    public RedstoneChannel(CompoundTag nbt) {
        this.frequency = WRUtils.readFrequency(nbt);
        ListTag transmitterNbts = nbt.getList("transmitters", 10);
        for (Tag transmitterNbt : transmitterNbts) {
            this.transmitters.add(NbtUtils.readBlockPos((CompoundTag)((CompoundTag)transmitterNbt)));
        }
    }

    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        WRUtils.writeFrequency(nbt, this.frequency);
        ListTag transmitterNbts = new ListTag();
        for (BlockPos pos : this.transmitters) {
            transmitterNbts.add((Object)NbtUtils.writeBlockPos((BlockPos)pos));
        }
        nbt.put("transmitters", (Tag)transmitterNbts);
        return nbt;
    }

    public void addTransmitter(Level world, BlockPos pos) {
        boolean empty = !this.isActive();
        this.transmitters.add(pos);
        if (empty) {
            this.updateReceivers(world);
        }
    }

    public void removeTransmitter(Level world, BlockPos pos) {
        this.transmitters.remove(pos);
        if (!this.isActive()) {
            this.updateReceivers(world);
        }
    }

    public void addReceiver(Level world, BlockPos pos) {
        this.receivers.add(pos);
        this.updateReceiver(world, pos);
    }

    public void removeReceiver(BlockPos pos) {
        this.receivers.remove(pos);
    }

    public void addRemote(Level world, LivingEntity owner) {
        boolean empty = !this.isActive();
        this.remotes.add(owner);
        if (empty) {
            this.updateReceivers(world);
        }
    }

    public void removeRemote(Level world, LivingEntity owner) {
        this.remotes.remove(owner);
        if (!this.isActive()) {
            this.updateReceivers(world);
        }
    }

    public void updateReceiver(Level world, BlockPos pos) {
        world.scheduleTick(pos, ModBlocks.redstoneReceiver, 2);
    }

    public void updateReceivers(Level world) {
        for (BlockPos receiver : this.receivers) {
            this.updateReceiver(world, receiver);
        }
    }

    public int getFrequency() {
        return this.frequency;
    }

    public Set<BlockPos> getTransmitters() {
        return this.transmitters;
    }

    public boolean isActive() {
        return !this.transmitters.isEmpty() || !this.remotes.isEmpty();
    }

    public boolean isEmpty() {
        return this.transmitters.isEmpty() && this.receivers.isEmpty() && this.remotes.isEmpty();
    }
}

