/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.ether;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import rzk.wirelessredstone.ether.RedstoneChannel;
import rzk.wirelessredstone.misc.WRUtils;

public class RedstoneEther
extends SavedData {
    private static final String DATA_NAME = "redstone_ether";
    private final Int2ObjectMap<RedstoneChannel> channels = new Int2ObjectOpenHashMap();
    private static final SavedData.Factory<RedstoneEther> TYPE = new SavedData.Factory(RedstoneEther::new, RedstoneEther::new, null);

    private RedstoneEther() {
    }

    private RedstoneEther(CompoundTag nbt) {
        ListTag channelTags = nbt.getList("channels", 10);
        for (Tag channelNbt : channelTags) {
            RedstoneChannel channel = new RedstoneChannel((CompoundTag)channelNbt);
            this.channels.put(channel.getFrequency(), (Object)channel);
        }
    }

    public CompoundTag save(CompoundTag nbt) {
        ListTag channelNbts = new ListTag();
        for (RedstoneChannel channel : this.channels.values()) {
            channelNbts.add((Object)channel.save());
        }
        nbt.put("channels", (Tag)channelNbts);
        return nbt;
    }

    public static RedstoneEther get(ServerLevel world) {
        return (RedstoneEther)world.getDataStorage().get(TYPE, DATA_NAME);
    }

    public static RedstoneEther getOrCreate(ServerLevel world) {
        return (RedstoneEther)world.getDataStorage().computeIfAbsent(TYPE, DATA_NAME);
    }

    private RedstoneChannel getChannel(int frequency) {
        return (RedstoneChannel)this.channels.get(frequency);
    }

    private RedstoneChannel getOrCreateChannel(int frequency) {
        RedstoneChannel channel = (RedstoneChannel)this.channels.get(frequency);
        if (channel == null) {
            channel = new RedstoneChannel(frequency);
            this.channels.put(frequency, (Object)channel);
        }
        return channel;
    }

    public void addTransmitter(Level world, BlockPos pos, int frequency) {
        if (!WRUtils.isValidFrequency(frequency)) {
            return;
        }
        this.getOrCreateChannel(frequency).addTransmitter(world, pos);
        this.setDirty();
    }

    public void addRemote(Level world, LivingEntity owner, int frequency) {
        if (!WRUtils.isValidFrequency(frequency)) {
            return;
        }
        this.getOrCreateChannel(frequency).addRemote(world, owner);
    }

    public void addReceiver(Level world, BlockPos pos, int frequency) {
        if (!WRUtils.isValidFrequency(frequency)) {
            return;
        }
        this.getOrCreateChannel(frequency).addReceiver(world, pos);
    }

    public void removeTransmitter(Level world, BlockPos pos, int frequency) {
        RedstoneChannel channel = this.getChannel(frequency);
        if (channel == null) {
            return;
        }
        channel.removeTransmitter(world, pos);
        if (channel.isEmpty()) {
            this.channels.remove(frequency);
        }
        this.setDirty();
    }

    public void removeRemote(Level world, LivingEntity owner, int frequency) {
        RedstoneChannel channel = this.getChannel(frequency);
        if (channel == null) {
            return;
        }
        channel.removeRemote(world, owner);
        if (channel.isEmpty()) {
            this.channels.remove(frequency);
            this.setDirty();
        }
    }

    public void removeReceiver(BlockPos pos, int frequency) {
        RedstoneChannel channel = this.getChannel(frequency);
        if (channel == null) {
            return;
        }
        channel.removeReceiver(pos);
        if (channel.isEmpty()) {
            this.channels.remove(frequency);
            this.setDirty();
        }
    }

    public Set<BlockPos> getTransmitters(int frequency) {
        RedstoneChannel channel = this.getChannel(frequency);
        return channel != null ? channel.getTransmitters() : Collections.emptySet();
    }

    public boolean isFrequencyActive(int frequency) {
        RedstoneChannel channel = this.getChannel(frequency);
        return channel != null && channel.isActive();
    }
}

