/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import rzk.wirelessredstone.WirelessRedstone;
import rzk.wirelessredstone.block.RedstoneTransceiverBlock;
import rzk.wirelessredstone.misc.WRUtils;

public class FrequencyItem
extends Item {
    public FrequencyItem(Item.Properties settings) {
        super(settings.stacksTo(1));
    }

    public int getFrequency(ItemStack stack) {
        return WRUtils.readFrequency(stack.getTag());
    }

    public void setFrequency(ItemStack stack, int frequency) {
        WRUtils.writeFrequency(stack.getOrCreateTag(), frequency);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level world = context.getLevel();
        Block block = world.getBlockState(pos = context.getClickedPos()).getBlock();
        if (block instanceof RedstoneTransceiverBlock) {
            int frequency;
            RedstoneTransceiverBlock transceiver = (RedstoneTransceiverBlock)block;
            Player player = context.getPlayer();
            ItemStack stack = context.getItemInHand();
            boolean isShift = player.isShiftKeyDown();
            int n = frequency = isShift ? transceiver.getFrequency(world, pos) : this.getFrequency(stack);
            if (!WRUtils.isValidFrequency(frequency)) {
                return InteractionResult.FAIL;
            }
            if (isShift) {
                this.setFrequency(stack, frequency);
            } else {
                transceiver.setFrequency(world, pos, frequency);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!player.isShiftKeyDown()) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (!world.isClientSide) {
            WirelessRedstone.PLATFORM.sendFrequencyItemPacket((ServerPlayer)player, this.getFrequency(stack), hand);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        int frequency = this.getFrequency(stack);
        if (!WRUtils.isValidFrequency(frequency)) {
            return;
        }
        MutableComponent frequencyComponent = Component.literal((String)String.valueOf(frequency)).withStyle(ChatFormatting.AQUA);
        tooltip.add((Component)Component.translatable((String)"item.wirelessredstone.tooltip.frequency", (Object[])new Object[]{frequencyComponent}).withStyle(ChatFormatting.GRAY));
    }
}

