/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.item;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import rzk.wirelessredstone.api.SelectedItemListener;
import rzk.wirelessredstone.ether.RedstoneEther;
import rzk.wirelessredstone.item.FrequencyItem;
import rzk.wirelessredstone.misc.WRUtils;

public class RemoteItem
extends FrequencyItem
implements SelectedItemListener {
    public RemoteItem(Item.Properties settings) {
        super(settings);
    }

    public void onDeactivation(ItemStack stack, Level world, LivingEntity owner) {
        if (!world.isClientSide) {
            RedstoneEther ether = RedstoneEther.get((ServerLevel)world);
            if (ether == null) {
                return;
            }
            int frequency = this.getFrequency(stack);
            ether.removeRemote(world, owner, frequency);
        }
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        if (context.getPlayer().isShiftKeyDown()) {
            return super.useOn(context);
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        if (player.isShiftKeyDown()) {
            return super.use(world, player, hand);
        }
        ItemStack stack = player.getItemInHand(hand);
        int frequency = this.getFrequency(stack);
        player.getCooldowns().addCooldown((Item)this, 10);
        if (!WRUtils.isValidFrequency(frequency)) {
            if (!world.isClientSide) {
                player.displayClientMessage((Component)Component.translatable((String)"message.wirelessredstone.no_frequency").withStyle(ChatFormatting.RED), true);
            }
            return InteractionResultHolder.consume((Object)stack);
        }
        player.startUsingItem(hand);
        if (!world.isClientSide) {
            RedstoneEther ether = RedstoneEther.getOrCreate((ServerLevel)world);
            ether.addRemote(world, (LivingEntity)player, frequency);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)false);
    }

    public int getUseDuration(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    @Override
    public void onSelectedItemDropped(ItemStack stack, ServerLevel world, ServerPlayer player) {
        if (!player.getUseItem().isEmpty()) {
            this.onDeactivation(stack, (Level)world, (LivingEntity)player);
        }
    }

    @Override
    public void onClearActiveItem(ItemStack stack, Level world, LivingEntity entity) {
        if (!world.isClientSide && !entity.getUseItem().isEmpty()) {
            this.onDeactivation(stack, world, entity);
        }
    }
}

