/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.item;

import java.util.ArrayList;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import rzk.wirelessredstone.WirelessRedstone;
import rzk.wirelessredstone.ether.RedstoneEther;
import rzk.wirelessredstone.item.FrequencyItem;
import rzk.wirelessredstone.misc.WRConfig;
import rzk.wirelessredstone.misc.WRUtils;
import rzk.wirelessredstone.registry.ModItems;

public class SnifferItem
extends FrequencyItem {
    public SnifferItem(Item.Properties settings) {
        super(settings);
    }

    public static BlockPos[] getHighlightedBlocks(ItemStack stack) {
        if (!stack.is(ModItems.frequencySniffer)) {
            return null;
        }
        CompoundTag nbt = stack.getTag();
        if (nbt == null) {
            return null;
        }
        ListTag list = nbt.getList("highlights", 10);
        if (list.isEmpty()) {
            return null;
        }
        BlockPos[] coords = new BlockPos[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            coords[i] = NbtUtils.readBlockPos((CompoundTag)list.getCompound(i));
        }
        return coords;
    }

    public static void setHighlightedBlocks(long timestamp, ItemStack stack, BlockPos[] coords) {
        if (!stack.is(ModItems.frequencySniffer)) {
            return;
        }
        CompoundTag nbt = stack.getOrCreateTag();
        nbt.putLong("timestamp", timestamp);
        ListTag list = new ListTag();
        for (BlockPos pos : coords) {
            list.add((Object)NbtUtils.writeBlockPos((BlockPos)pos));
        }
        nbt.put("highlights", (Tag)list);
    }

    private static void removeHighlightBlocks(ItemStack stack) {
        CompoundTag nbt = stack.getTag();
        if (nbt == null) {
            return;
        }
        nbt.remove("timestamp");
        nbt.remove("highlights");
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        if (!context.getPlayer().isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        return super.useOn(context);
    }

    private Component buildActiveTransmittersMessage(Player player, Set<BlockPos> transmitters, Component frequencyText) {
        ArrayList<MutableComponent> texts = new ArrayList<MutableComponent>();
        texts.add(Component.translatable((String)"message.wirelessredstone.transmitters.active", (Object[])new Object[]{frequencyText, transmitters.size()}));
        for (BlockPos pos : transmitters) {
            if (texts.size() > 20) {
                texts.add(Component.literal((String)"..."));
                break;
            }
            MutableComponent text = WRUtils.positionText(pos);
            texts.add(text);
            if (!player.hasPermissions(2)) continue;
            String teleportCommand = String.format("/tp %d %d %d", pos.getX(), pos.getY() + 1, pos.getZ());
            ClickEvent click = new ClickEvent(ClickEvent.Action.RUN_COMMAND, teleportCommand);
            HoverEvent hover = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"message.wirelessredstone.teleport"));
            text.setStyle(text.getStyle().withClickEvent(click).withHoverEvent(hover));
        }
        return ComponentUtils.formatList(texts, (Component)Component.literal((String)"\n"));
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        if (player.isShiftKeyDown()) {
            return super.use(world, player, hand);
        }
        ItemStack stack = player.getItemInHand(hand);
        int frequency = this.getFrequency(stack);
        if (!WRUtils.isValidFrequency(frequency)) {
            if (world.isClientSide) {
                player.displayClientMessage((Component)Component.translatable((String)"message.wirelessredstone.no_frequency").withStyle(ChatFormatting.RED), true);
            }
            return InteractionResultHolder.fail((Object)stack);
        }
        player.getCooldowns().addCooldown((Item)this, 20);
        InteractionResultHolder result = InteractionResultHolder.success((Object)stack);
        if (world.isClientSide) {
            return result;
        }
        MutableComponent frequencyText = WRUtils.frequencyText(frequency);
        RedstoneEther ether = RedstoneEther.get((ServerLevel)world);
        if (ether == null) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.wirelessredstone.transmitters.empty", (Object[])new Object[]{frequencyText}));
            return result;
        }
        Set<BlockPos> transmitters = ether.getTransmitters(frequency);
        if (transmitters.isEmpty()) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.wirelessredstone.transmitters.empty", (Object[])new Object[]{frequencyText}));
            SnifferItem.removeHighlightBlocks(stack);
        } else {
            Component message = this.buildActiveTransmittersMessage(player, transmitters, (Component)frequencyText);
            player.sendSystemMessage(message);
            WirelessRedstone.PLATFORM.sendSniffer((ServerPlayer)player, world.getGameTime(), hand, (BlockPos[])transmitters.toArray(BlockPos[]::new));
        }
        return result;
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        CompoundTag nbt = stack.getTag();
        if (!selected || !world.isClientSide || nbt == null) {
            return;
        }
        long timeOffset = (long)WRConfig.highlightTimeSeconds * 20L;
        if (world.getGameTime() >= nbt.getLong("timestamp") + timeOffset) {
            SnifferItem.removeHighlightBlocks(stack);
        }
    }
}

