/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.misc;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class WRUtils {
    public static final int MIN_FREQUENCY = 0;
    public static final int MAX_FREQUENCY = 99999;
    public static final int INVALID_FREQUENCY = -1;

    public static boolean isValidFrequency(int frequency) {
        return frequency >= 0 && frequency <= 99999;
    }

    public static void writeFrequency(CompoundTag nbt, int frequency) {
        if (nbt == null || !WRUtils.isValidFrequency(frequency)) {
            return;
        }
        nbt.putInt("frequency", frequency);
    }

    public static int readFrequency(CompoundTag nbt) {
        if (nbt == null || !nbt.contains("frequency")) {
            return -1;
        }
        return nbt.getInt("frequency");
    }

    public static int clamp(int min, int max, int value) {
        return Math.min(Math.max(min, value), max);
    }

    public static MutableComponent frequencyText(int frequency) {
        return Component.literal((String)String.valueOf(frequency)).withStyle(ChatFormatting.AQUA);
    }

    public static MutableComponent positionText(BlockPos pos) {
        MutableComponent x = Component.literal((String)String.valueOf(pos.getX())).withStyle(ChatFormatting.YELLOW);
        MutableComponent y = Component.literal((String)String.valueOf(pos.getY())).withStyle(ChatFormatting.YELLOW);
        MutableComponent z = Component.literal((String)String.valueOf(pos.getZ())).withStyle(ChatFormatting.YELLOW);
        return Component.translatable((String)"item.wirelessredstone.tooltip.position", (Object[])new Object[]{x, y, z}).withStyle(ChatFormatting.WHITE);
    }
}

