/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.network;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import rzk.wirelessredstone.WirelessRedstone;
import rzk.wirelessredstone.block.RedstoneTransceiverBlock;
import rzk.wirelessredstone.client.screen.ModScreens;

public record FrequencyBlockPacket(int frequency, BlockPos pos) implements CustomPacketPayload
{
    public static final ResourceLocation ID = WirelessRedstone.identifier("frequency_block");

    public FrequencyBlockPacket(FriendlyByteBuf buf) {
        this(buf.readInt(), buf.readBlockPos());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.frequency);
        buf.writeBlockPos(this.pos);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handleServer(IPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            Block patt1291$temp;
            Level world = (Level)ctx.level().orElseThrow();
            if (world.isAreaLoaded(this.pos, 0) && (patt1291$temp = world.getBlockState(this.pos).getBlock()) instanceof RedstoneTransceiverBlock) {
                RedstoneTransceiverBlock block = (RedstoneTransceiverBlock)patt1291$temp;
                block.setFrequency(world, this.pos, this.frequency);
            }
        }).exceptionally(e -> {
            ctx.packetHandler().disconnect((Component)Component.translatable((String)"networking.wirelessredstone.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleClient(IPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                ModScreens.openBlockFrequencyScreen(this.frequency, this.pos);
            }
        }).exceptionally(e -> {
            ctx.packetHandler().disconnect((Component)Component.translatable((String)"networking.wirelessredstone.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

