/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import rzk.wirelessredstone.WirelessRedstone;
import rzk.wirelessredstone.client.screen.ModScreens;
import rzk.wirelessredstone.item.FrequencyItem;

public record FrequencyItemPacket(int frequency, InteractionHand hand) implements CustomPacketPayload
{
    public static final ResourceLocation ID = WirelessRedstone.identifier("frequency_item");

    public FrequencyItemPacket(FriendlyByteBuf buf) {
        this(buf.readInt(), buf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.frequency);
        buf.writeBoolean(this.hand == InteractionHand.MAIN_HAND);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handleServer(IPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            Player player = (Player)ctx.player().orElseThrow();
            ItemStack stack = player.getItemInHand(this.hand);
            Item patt1375$temp = stack.getItem();
            if (patt1375$temp instanceof FrequencyItem) {
                FrequencyItem item = (FrequencyItem)patt1375$temp;
                item.setFrequency(stack, this.frequency);
            }
        }).exceptionally(e -> {
            ctx.packetHandler().disconnect((Component)Component.translatable((String)"networking.wirelessredstone.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleClient(IPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                ModScreens.openItemFrequencyScreen(this.frequency, this.hand);
            }
        }).exceptionally(e -> {
            ctx.packetHandler().disconnect((Component)Component.translatable((String)"networking.wirelessredstone.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

