/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.network;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import rzk.wirelessredstone.WirelessRedstone;
import rzk.wirelessredstone.client.render.WRWorldRendererNeo;

public record SnifferHighlightPacket(long timestamp, InteractionHand hand, BlockPos[] coords) implements CustomPacketPayload
{
    public static final ResourceLocation ID = WirelessRedstone.identifier("sniffer_highlight");

    public SnifferHighlightPacket(FriendlyByteBuf buf) {
        this(buf.readLong(), buf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, SnifferHighlightPacket.readCoords(buf));
    }

    private static BlockPos[] readCoords(FriendlyByteBuf buf) {
        BlockPos[] coords = new BlockPos[buf.readInt()];
        for (int i = 0; i < coords.length; ++i) {
            coords[i] = buf.readBlockPos();
        }
        return coords;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeLong(this.timestamp);
        buf.writeBoolean(this.hand == InteractionHand.MAIN_HAND);
        buf.writeInt(this.coords.length);
        for (BlockPos pos : this.coords) {
            buf.writeBlockPos(pos);
        }
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(IPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                WRWorldRendererNeo.handleSnifferHighlightPacket(this.timestamp, this.hand, this.coords);
            }
        }).exceptionally(e -> {
            ctx.packetHandler().disconnect((Component)Component.translatable((String)"networking.wirelessredstone.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

