/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.platform;

import java.io.File;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.network.PacketDistributor;
import rzk.wirelessredstone.network.FrequencyBlockPacket;
import rzk.wirelessredstone.network.FrequencyItemPacket;
import rzk.wirelessredstone.network.SnifferHighlightPacket;
import rzk.wirelessredstone.platform.Platform;
import rzk.wirelessredstone.platform.PlatformLoader;

public class PlatformNeo
implements Platform {
    @Override
    public PlatformLoader getLoader() {
        return PlatformLoader.NEOFORGE;
    }

    @Override
    public File getConfigDir() {
        return FMLPaths.CONFIGDIR.get().toFile();
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public void sendFrequencyItemPacket(ServerPlayer player, int frequency, InteractionHand hand) {
        PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{new FrequencyItemPacket(frequency, hand)});
    }

    @Override
    public void sendFrequencyBlockPacket(ServerPlayer player, int frequency, BlockPos pos) {
        PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{new FrequencyBlockPacket(frequency, pos)});
    }

    @Override
    public void sendSniffer(ServerPlayer player, long time, InteractionHand hand, BlockPos[] transmitters) {
        PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{new SnifferHighlightPacket(time, hand, transmitters)});
    }
}

