/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import rzk.wirelessredstone.block.entity.RedstoneTransceiverBlockEntity;
import rzk.wirelessredstone.misc.WRConfig;
import rzk.wirelessredstone.misc.WRUtils;

public class RedstoneTransceiverBER<T extends RedstoneTransceiverBlockEntity>
implements BlockEntityRenderer<T> {
    private final Font textRenderer;

    public RedstoneTransceiverBER(BlockEntityRendererProvider.Context ctx) {
        this.textRenderer = ctx.getFont();
    }

    public void render(T entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        int frequency = ((RedstoneTransceiverBlockEntity)((Object)entity)).getFrequency();
        if (!WRUtils.isValidFrequency(frequency)) {
            return;
        }
        String str = String.valueOf(frequency);
        float textOffset = (float)(-this.textRenderer.width(str)) / 2.0f;
        matrices.pushPose();
        matrices.translate(0.5, 1.0, 0.5);
        for (int i = 0; i < 4; ++i) {
            matrices.pushPose();
            matrices.mulPose(Axis.YP.rotation((float)((double)i * Math.PI / 2.0)));
            matrices.translate(0.0, 0.0, 0.5078125);
            matrices.scale(0.010416667f, -0.010416667f, 0.010416667f);
            this.textRenderer.drawInBatch(str, textOffset, 2.5f, WRConfig.frequencyDisplayColor, false, matrices.last().pose(), vertexConsumers, Font.DisplayMode.POLYGON_OFFSET, 0, 0xFFFFFF);
            matrices.popPose();
        }
        matrices.popPose();
    }
}

