/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import rzk.wirelessredstone.item.SnifferItem;
import rzk.wirelessredstone.misc.WRConfig;

public class WRWorldRenderer {
    public static void renderAfterTranslucent(Level world, Vec3 cameraPosition, PoseStack matrixStack, float tickDelta) {
        matrixStack.pushPose();
        matrixStack.translate(-cameraPosition.x, -cameraPosition.y, -cameraPosition.z);
        LocalPlayer player = Minecraft.getInstance().player;
        ItemStack stack = player.getMainHandItem();
        WRWorldRenderer.renderSnifferHighlights((Player)player, stack, matrixStack);
        matrixStack.popPose();
    }

    private static void renderSnifferHighlights(Player player, ItemStack stack, PoseStack matrixStack) {
        BlockPos[] coords = SnifferItem.getHighlightedBlocks(stack);
        if (coords == null) {
            coords = SnifferItem.getHighlightedBlocks(player.getOffhandItem());
        }
        if (coords == null) {
            return;
        }
        float red = (float)(WRConfig.highlightColor >> 16 & 0xFF) / 256.0f;
        float green = (float)(WRConfig.highlightColor >> 8 & 0xFF) / 256.0f;
        float blue = (float)(WRConfig.highlightColor & 0xFF) / 256.0f;
        RenderSystem.assertOnRenderThread();
        GlStateManager._depthMask((boolean)false);
        GlStateManager._disableCull();
        RenderSystem.disableDepthTest();
        RenderSystem.lineWidth((float)3.0f);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getRendertypeLinesShader);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder builder = tessellator.getBuilder();
        builder.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
        for (BlockPos pos : coords) {
            player.shouldRender((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            LevelRenderer.renderLineBox((PoseStack)matrixStack, (VertexConsumer)builder, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1), (float)red, (float)green, (float)blue, (float)1.0f);
        }
        tessellator.end();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.lineWidth((float)1.0f);
    }
}

